/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats.fs;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.shared.system.stats.SigarService;
import org.graylog2.shared.system.stats.fs.FsProbe;
import org.graylog2.shared.system.stats.fs.FsStats;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class SigarFsProbe
implements FsProbe {
    private final SigarService sigarService;
    private final Set<File> locations;
    private final Map<File, FileSystem> sigarFileSystems = new HashMap<File, FileSystem>();

    @Inject
    public SigarFsProbe(SigarService sigarService, @Named(value="message_journal_dir") File journalDirectory) {
        this.sigarService = sigarService;
        this.locations = ImmutableSet.of((Object)journalDirectory);
    }

    @Override
    public synchronized FsStats fsStats() {
        Sigar sigar = this.sigarService.sigar();
        HashMap<String, FsStats.Filesystem> filesystems = new HashMap<String, FsStats.Filesystem>(this.locations.size());
        for (File location : this.locations) {
            String path = location.getAbsolutePath();
            try {
                FileSystemMap fileSystemMap;
                FileSystem fileSystem = this.sigarFileSystems.get(location);
                if (fileSystem == null && (fileSystemMap = sigar.getFileSystemMap()) != null) {
                    fileSystem = fileSystemMap.getMountPoint(location.getPath());
                    this.sigarFileSystems.put(location, fileSystem);
                }
                String mount = null;
                String dev = null;
                long total = -1L;
                long free = -1L;
                long available = -1L;
                long used = -1L;
                short usedPercent = -1;
                long inodesTotal = -1L;
                long inodesFree = -1L;
                long inodesUsed = -1L;
                short inodesUsedPercent = -1;
                long diskReads = -1L;
                long diskWrites = -1L;
                long diskReadBytes = -1L;
                long diskWriteBytes = -1L;
                double diskQueue = -1.0;
                double diskServiceTime = -1.0;
                if (fileSystem != null) {
                    mount = fileSystem.getDirName();
                    dev = fileSystem.getDevName();
                    FileSystemUsage fileSystemUsage = sigar.getFileSystemUsage(mount);
                    if (fileSystemUsage != null) {
                        total = fileSystemUsage.getTotal() * 1024L;
                        free = fileSystemUsage.getFree() * 1024L;
                        available = fileSystemUsage.getAvail() * 1024L;
                        used = fileSystemUsage.getUsed() * 1024L;
                        usedPercent = (short)(fileSystemUsage.getUsePercent() * 100.0);
                        inodesTotal = fileSystemUsage.getFiles();
                        inodesFree = fileSystemUsage.getFreeFiles();
                        inodesUsed = inodesTotal - inodesFree;
                        inodesUsedPercent = (short)((double)inodesUsed / (double)inodesTotal * 100.0);
                        diskReads = fileSystemUsage.getDiskReads();
                        diskWrites = fileSystemUsage.getDiskWrites();
                        diskReadBytes = fileSystemUsage.getDiskReadBytes();
                        diskWriteBytes = fileSystemUsage.getDiskWriteBytes();
                        diskQueue = fileSystemUsage.getDiskQueue();
                        diskServiceTime = fileSystemUsage.getDiskServiceTime();
                    }
                }
                FsStats.Filesystem filesystem = FsStats.Filesystem.create(path, mount, dev, total, free, available, used, usedPercent, inodesTotal, inodesFree, inodesUsed, inodesUsedPercent, diskReads, diskWrites, diskReadBytes, diskWriteBytes, diskQueue, diskServiceTime);
                filesystems.put(path, filesystem);
            }
            catch (SigarException sigarException) {}
        }
        return FsStats.create(filesystems);
    }
}

