/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats.network;

import com.google.common.base.Strings;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.graylog2.shared.system.stats.network.NetworkProbe;
import org.graylog2.shared.system.stats.network.NetworkStats;

public class JmxNetworkProbe
implements NetworkProbe {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    @Override
    public NetworkStats networkStats() {
        String primaryInterface = null;
        HashMap<String, NetworkStats.Interface> interfaces = new HashMap<String, NetworkStats.Interface>();
        try {
            String localAddress = Strings.nullToEmpty((String)InetAddress.getLocalHost().getHostAddress());
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netIf : Collections.list(networkInterfaces)) {
                String name = netIf.getName();
                NetworkStats.Interface networkInterface = this.buildInterface(netIf);
                interfaces.put(name, networkInterface);
                if (!networkInterface.addresses().contains(localAddress)) continue;
                primaryInterface = name;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return NetworkStats.create(primaryInterface, interfaces, null);
    }

    private NetworkStats.Interface buildInterface(NetworkInterface networkInterface) throws SocketException {
        String macAddress = this.bytesToMacAddressString(networkInterface.getHardwareAddress());
        List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
        HashSet<String> addresses = new HashSet<String>(interfaceAddresses.size());
        for (InterfaceAddress interfaceAddress : interfaceAddresses) {
            addresses.add(interfaceAddress.getAddress().getHostAddress());
        }
        return NetworkStats.Interface.create(networkInterface.getName(), addresses, macAddress, networkInterface.getMTU(), null);
    }

    private String bytesToMacAddressString(byte[] bytes) {
        if (null == bytes) {
            return "00:00:00:00:00:00";
        }
        char[] hexChars = new char[bytes.length * 2 + 5];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 3] = hexArray[v >>> 4];
            hexChars[i * 3 + 1] = hexArray[v & 0xF];
            if (i >= bytes.length - 1) continue;
            hexChars[i * 3 + 2] = 58;
        }
        return new String(hexChars);
    }
}

