/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.CollectionName;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.outputs.OutputRegistry;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.streams.Output;
import org.graylog2.rest.models.streams.outputs.requests.CreateOutputRequest;
import org.graylog2.streams.OutputImpl;
import org.graylog2.streams.OutputService;
import org.graylog2.streams.StreamService;
import org.mongojack.DBQuery;
import org.mongojack.DBUpdate;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class OutputServiceImpl
implements OutputService {
    private final JacksonDBCollection<OutputImpl, String> coll;
    private final DBCollection dbCollection;
    private final StreamService streamService;
    private final OutputRegistry outputRegistry;

    @Inject
    public OutputServiceImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapperProvider, StreamService streamService, OutputRegistry outputRegistry) {
        this.streamService = streamService;
        String collectionName = OutputImpl.class.getAnnotation(CollectionName.class).value();
        this.dbCollection = mongoConnection.getDatabase().getCollection(collectionName);
        this.coll = JacksonDBCollection.wrap((DBCollection)this.dbCollection, OutputImpl.class, String.class, (ObjectMapper)mapperProvider.get());
        this.outputRegistry = outputRegistry;
    }

    @Override
    public Output load(String streamOutputId) throws NotFoundException {
        Output output = (Output)this.coll.findOneById((Object)streamOutputId);
        if (output == null) {
            throw new NotFoundException("Couldn't find output with id " + streamOutputId);
        }
        return output;
    }

    @Override
    public Set<Output> loadAll() {
        return this.toAbstractSetType(this.coll.find().toArray());
    }

    private Set<Output> toAbstractSetType(List<OutputImpl> outputs) {
        HashSet result = Sets.newHashSet();
        result.addAll(outputs);
        return result;
    }

    @Override
    public Output create(Output request) throws ValidationException {
        OutputImpl outputImpl = this.implOrFail(request);
        WriteResult writeResult = this.coll.save((Object)outputImpl);
        return (Output)writeResult.getSavedObject();
    }

    @Override
    public Output create(CreateOutputRequest request, String userId) throws ValidationException {
        return this.create(OutputImpl.create(new ObjectId().toHexString(), request.title(), request.type(), userId, request.configuration(), Tools.nowUTC().toDate(), request.contentPack()));
    }

    @Override
    public void destroy(Output model) throws NotFoundException {
        this.coll.removeById((Object)model.getId());
        this.outputRegistry.removeOutput(model);
        this.streamService.removeOutputFromAllStreams(model);
    }

    @Override
    public Output update(String id, Map<String, Object> deltas) {
        DBUpdate.Builder update = new DBUpdate.Builder();
        for (Map.Entry<String, Object> fields : deltas.entrySet()) {
            update = update.set(fields.getKey(), fields.getValue());
        }
        return (Output)this.coll.findAndModify(DBQuery.is((String)"_id", (Object)id), update);
    }

    @Override
    public long count() {
        return this.coll.count();
    }

    @Override
    public Map<String, Long> countByType() {
        DBCursor outputTypes = this.dbCollection.find(null, (DBObject)new BasicDBObject("type", (Object)1));
        HashMap<String, Long> outputsCountByType = new HashMap<String, Long>(outputTypes.count());
        for (DBObject outputType : outputTypes) {
            String type = (String)outputType.get("type");
            if (type == null) continue;
            Long oldValue = (Long)outputsCountByType.get(type);
            Long newValue = oldValue == null ? 1L : oldValue + 1L;
            outputsCountByType.put(type, newValue);
        }
        return outputsCountByType;
    }

    private OutputImpl implOrFail(Output output) {
        if (output instanceof OutputImpl) {
            OutputImpl outputImpl = (OutputImpl)output;
            return outputImpl;
        }
        throw new IllegalArgumentException("Supplied output must be of implementation type OutputImpl, not " + output.getClass());
    }
}

