/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams.matchers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.streams.StreamRule;
import org.graylog2.streams.matchers.StreamRuleMatcher;
import org.graylog2.utilities.InterruptibleCharSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexMatcher
implements StreamRuleMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(RegexMatcher.class);
    private static final long CACHESIZE = 1000L;
    private static final LoadingCache<String, Pattern> patternCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, Pattern>(){

        public Pattern load(String key) throws Exception {
            return Pattern.compile(key, 32);
        }
    });

    @Override
    public boolean match(Message msg, StreamRule rule) {
        if (msg.getField(rule.getField()) == null) {
            return rule.getInverted();
        }
        try {
            Pattern pattern = (Pattern)patternCache.get((Object)rule.getValue());
            InterruptibleCharSequence charSequence = new InterruptibleCharSequence(msg.getField(rule.getField()).toString());
            return rule.getInverted() ^ pattern.matcher(charSequence).find();
        }
        catch (ExecutionException e) {
            LOG.error("Unable to get pattern from regex cache: ", (Throwable)e);
            return false;
        }
    }
}

