/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.utilities;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.database.ValidationException;

public class ConfigurationMapConverter {
    public static Map<String, Object> convertValues(Map<String, Object> data, ConfigurationRequest configurationRequest) throws ValidationException {
        HashMap configuration = Maps.newHashMapWithExpectedSize((int)data.size());
        Map<String, Map<String, Object>> configurationFields = configurationRequest.asList();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            List value;
            String type;
            String field = entry.getKey();
            Map<String, Object> fieldDescription = configurationFields.get(field);
            if (fieldDescription == null || fieldDescription.isEmpty()) {
                throw new ValidationException(field, "Unknown configuration field description for field \"" + field + "\"");
            }
            switch (type = (String)fieldDescription.get("type")) {
                case "text": 
                case "dropdown": {
                    value = entry.getValue() == null ? "" : String.valueOf(entry.getValue());
                    break;
                }
                case "number": {
                    try {
                        value = Integer.parseInt(String.valueOf(entry.getValue()));
                        break;
                    }
                    catch (NumberFormatException e) {
                        if ("true".equals(String.valueOf(fieldDescription.get("is_optional")))) {
                            value = null;
                            break;
                        }
                        throw new ValidationException(field, e.getMessage());
                    }
                }
                case "boolean": {
                    value = "true".equalsIgnoreCase(String.valueOf(entry.getValue()));
                    break;
                }
                case "list": {
                    List valueList = entry.getValue() == null ? Collections.emptyList() : (List)entry.getValue();
                    value = valueList.stream().filter(o -> o != null && o instanceof String).map(String::valueOf).collect(Collectors.toList());
                    break;
                }
                default: {
                    throw new ValidationException(field, "Unknown configuration field type \"" + type + "\"");
                }
            }
            configuration.put(field, value);
        }
        return configuration;
    }
}

