/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.utilities;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Service;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingServiceListener
extends Service.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingServiceListener.class);
    private final String serviceName;
    private String id;
    @Nullable
    private Runnable action;
    private final Logger logger;

    public LoggingServiceListener(String serviceName, String id) {
        this(serviceName, id, null, LOG);
    }

    public LoggingServiceListener(String serviceName, String id, @NotNull Logger logger) {
        this(serviceName, id, null, logger);
    }

    public LoggingServiceListener(String serviceName, String id, @Nullable Runnable action, @NotNull Logger logger) {
        this.serviceName = serviceName;
        this.id = id;
        this.action = action;
        this.logger = (Logger)Preconditions.checkNotNull((Object)logger);
    }

    public void starting() {
        this.logger.info("{} {} STARTING", (Object)this.serviceName, (Object)this.id);
    }

    public void running() {
        this.logger.info("{} {} RUNNING", (Object)this.serviceName, (Object)this.id);
        if (this.action != null) {
            this.action.run();
        }
    }

    public void stopping(Service.State from) {
        this.logger.info("{} {} STOPPING, was {}", new Object[]{this.serviceName, this.id, from});
    }

    public void terminated(Service.State from) {
        this.logger.info("{} {} TERMINATED, was {}", new Object[]{this.serviceName, this.id, from});
    }

    public void failed(Service.State from, Throwable failure) {
        this.logger.info("{} {} FAILED, was {}: {}", new Object[]{this.serviceName, this.id, from, ExceptionUtils.getRootCauseMessage(failure)});
    }
}

