/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.unix;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import org.graylog2.syslog4j.SyslogMessageProcessorIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.AbstractSyslog;
import org.graylog2.syslog4j.impl.AbstractSyslogWriter;
import org.graylog2.syslog4j.impl.unix.UnixSyslogConfig;
import org.graylog2.syslog4j.util.OSDetectUtility;

public class UnixSyslog
extends AbstractSyslog {
    private static final long serialVersionUID = 4973353204252276740L;
    protected UnixSyslogConfig unixSyslogConfig = null;
    protected static Memory identBuffer = null;
    protected static int currentFacility = -1;
    protected static boolean openlogCalled = false;
    protected static CLibrary libraryInstance = null;

    protected static synchronized void loadLibrary(UnixSyslogConfig config) throws SyslogRuntimeException {
        if (!OSDetectUtility.isUnix()) {
            throw new SyslogRuntimeException("UnixSyslog not supported on non-Unix platforms");
        }
        if (libraryInstance == null) {
            libraryInstance = (CLibrary)Native.loadLibrary((String)config.getLibrary(), CLibrary.class);
        }
    }

    @Override
    public void initialize() throws SyslogRuntimeException {
        try {
            this.unixSyslogConfig = (UnixSyslogConfig)this.syslogConfig;
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException("config must be of type UnixSyslogConfig");
        }
        UnixSyslog.loadLibrary(this.unixSyslogConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void write(int level, String message, UnixSyslogConfig config) throws SyslogRuntimeException {
        CLibrary cLibrary = libraryInstance;
        synchronized (cLibrary) {
            if (currentFacility != config.getFacility()) {
                if (openlogCalled) {
                    libraryInstance.closelog();
                    openlogCalled = false;
                }
                currentFacility = config.getFacility();
            }
            if (!openlogCalled) {
                String ident = config.getIdent();
                if (ident != null && "".equals(ident.trim())) {
                    ident = null;
                }
                if (ident != null) {
                    identBuffer = new Memory(128L);
                    identBuffer.setString(0L, ident, false);
                }
                libraryInstance.openlog(identBuffer, config.getOption(), currentFacility);
                openlogCalled = true;
            }
            int priority = currentFacility | level;
            libraryInstance.syslog(priority, "%s", message);
        }
    }

    @Override
    protected void write(int level, byte[] message) throws SyslogRuntimeException {
    }

    @Override
    public void log(SyslogMessageProcessorIF messageProcessor, int level, String message) {
        UnixSyslog.write(level, message, this.unixSyslogConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws SyslogRuntimeException {
        CLibrary cLibrary = libraryInstance;
        synchronized (cLibrary) {
            libraryInstance.closelog();
            openlogCalled = false;
        }
    }

    @Override
    public void shutdown() throws SyslogRuntimeException {
        this.flush();
    }

    @Override
    public AbstractSyslogWriter getWriter() {
        return null;
    }

    @Override
    public void returnWriter(AbstractSyslogWriter syslogWriter) {
    }

    protected static interface CLibrary
    extends Library {
        public void openlog(Memory var1, int var2, int var3);

        public void syslog(int var1, String var2, String var3);

        public void closelog();
    }
}

