/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.internal.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.spi.AuditConfiguration;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.internal.impl.AbstractAuditQuery;

public class EntitiesAtRevisionQuery
extends AbstractAuditQuery {
    private final Number revision;
    private final boolean includeDeletions;

    public EntitiesAtRevisionQuery(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, Class<?> cls, Number revision, boolean includeDeletions) {
        super(verCfg, versionsReader, cls);
        this.revision = revision;
        this.includeDeletions = includeDeletions;
    }

    public EntitiesAtRevisionQuery(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, Class<?> cls, String entityName, Number revision, boolean includeDeletions) {
        super(verCfg, versionsReader, cls, entityName);
        this.revision = revision;
        this.includeDeletions = includeDeletions;
    }

    @Override
    public List list() {
        AuditEntitiesConfiguration verEntCfg = this.verCfg.getAuditEntCfg();
        String revisionPropertyPath = verEntCfg.getRevisionNumberPath();
        String originalIdPropertyName = verEntCfg.getOriginalIdPropName();
        MiddleIdData referencedIdData = new MiddleIdData(verEntCfg, this.verCfg.getEntCfg().get(this.entityName).getIdMappingData(), null, this.entityName, this.verCfg.getEntCfg().isVersioned(this.entityName));
        this.verCfg.getAuditStrategy().addEntityAtRevisionRestriction(this.verCfg.getGlobalCfg(), this.qb, this.qb.getRootParameters(), revisionPropertyPath, verEntCfg.getRevisionEndFieldName(), true, referencedIdData, revisionPropertyPath, originalIdPropertyName, "e__", "e2__", true);
        if (!this.includeDeletions) {
            this.qb.getRootParameters().addWhereWithParam(verEntCfg.getRevisionTypePropName(), "<>", (Object)RevisionType.DEL);
        }
        for (AuditCriterion criterion : this.criterions) {
            criterion.addToQuery(this.verCfg, this.versionsReader, this.entityName, this.qb, this.qb.getRootParameters());
        }
        Query query = this.buildQuery();
        List<String> params = Arrays.asList(query.getNamedParameters());
        if (params.contains("revision")) {
            query.setParameter("revision", (Object)this.revision);
        }
        List queryResult = query.list();
        if (this.hasProjection) {
            return queryResult;
        }
        ArrayList result = new ArrayList();
        this.entityInstantiator.addInstancesFromVersionsEntities(this.entityName, result, queryResult, this.revision);
        return result;
    }
}

