/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.SnowballPorterFilter;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;
import org.tartarus.snowball.SnowballProgram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnowballPorterFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    public static final String PROTECTED_TOKENS = "protected";
    private String language = "English";
    private Class stemClass;
    private CharArraySet protectedWords = null;

    @Override
    public void inform(ResourceLoader loader) {
        String wordFiles = (String)this.args.get(PROTECTED_TOKENS);
        if (wordFiles != null) {
            try {
                File protectedWordFiles = new File(wordFiles);
                if (protectedWordFiles.exists()) {
                    List<String> wlist = loader.getLines(wordFiles);
                    this.protectedWords = new CharArraySet(wlist, false);
                } else {
                    List<String> files = StrUtils.splitFileNames(wordFiles);
                    for (String file : files) {
                        List<String> wlist = loader.getLines(file.trim());
                        if (this.protectedWords == null) {
                            this.protectedWords = new CharArraySet(wlist, false);
                            continue;
                        }
                        this.protectedWords.addAll(wlist);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void init(Map<String, String> args) {
        super.init((Map)args);
        String cfgLanguage = args.get("language");
        if (cfgLanguage != null) {
            this.language = cfgLanguage;
        }
        try {
            this.stemClass = Class.forName("org.tartarus.snowball.ext." + this.language + "Stemmer");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find class for stemmer language " + this.language, e);
        }
    }

    public SnowballPorterFilter create(TokenStream input) {
        SnowballProgram program;
        try {
            program = (SnowballProgram)this.stemClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating stemmer for language " + this.language + "from class " + this.stemClass, e);
        }
        return new SnowballPorterFilter(input, program, this.protectedWords);
    }
}

