/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer;

import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.analyzer.AlarmEntity;
import org.hibernate.search.test.analyzer.MyEntity;
import org.hibernate.search.test.util.TestForIssue;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

@TestForIssue(jiraKey="HSEARCH-263")
public class DoubleAnalyzerTest
extends SearchTestCase {
    public static final Log log = LoggerFactory.make();

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{MyEntity.class, AlarmEntity.class};
    }

    public void testScopedAnalyzers() throws Exception {
        MyEntity en = new MyEntity();
        en.setEntity("anyNotNull");
        AlarmEntity alarmEn = new AlarmEntity();
        alarmEn.setProperty("notNullAgain");
        alarmEn.setAlarmDescription("description");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)en);
        s.persist((Object)alarmEn);
        tx.commit();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.standardAnalyzer);
        MatchAllDocsQuery luceneQuery = new MatchAllDocsQuery();
        FullTextQuery query = s.createFullTextQuery((Query)luceneQuery, new Class[0]);
        DoubleAnalyzerTest.assertEquals((int)2, (int)query.getResultSize());
        luceneQuery = parser.parse("entity:alarm");
        query = s.createFullTextQuery((Query)luceneQuery, new Class[]{MyEntity.class});
        DoubleAnalyzerTest.assertEquals((int)1, (int)query.getResultSize());
        luceneQuery = parser.parse("property:sound");
        query = s.createFullTextQuery((Query)luceneQuery, new Class[]{AlarmEntity.class});
        DoubleAnalyzerTest.assertEquals((int)0, (int)query.getResultSize());
        luceneQuery = parser.parse("description_analyzer2:sound");
        query = s.createFullTextQuery((Query)luceneQuery, new Class[]{AlarmEntity.class});
        DoubleAnalyzerTest.assertEquals((int)1, (int)query.getResultSize());
        luceneQuery = parser.parse("description_analyzer3:music");
        query = s.createFullTextQuery((Query)luceneQuery, new Class[]{AlarmEntity.class});
        DoubleAnalyzerTest.assertEquals((int)1, (int)query.getResultSize());
        tx.commit();
        s.close();
    }
}

