/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.solr.analysis.TokenizerFactory;

public abstract class TestTokenizer
extends Tokenizer
implements TokenizerFactory {
    private final CharTermAttribute termAttribute = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private int i = 0;

    public TestTokenizer(Reader input) {
        super(input);
    }

    public abstract String[] getTokens();

    public final boolean incrementToken() throws IOException {
        if (this.i < this.getTokens().length) {
            this.clearAttributes();
            this.termAttribute.append(this.getTokens()[this.i]);
            ++this.i;
            return true;
        }
        return false;
    }

    public void init(Map<String, String> args) {
    }

    public Map<String, String> getArgs() {
        return Collections.emptyMap();
    }

    public static class TestTokenizer3
    extends TestTokenizer {
        private final String[] tokens = new String[]{"mouse"};

        public TestTokenizer3() {
            super(null);
        }

        @Override
        public String[] getTokens() {
            return this.tokens;
        }

        public Tokenizer create(Reader input) {
            return this;
        }
    }

    public static class TestTokenizer2
    extends TestTokenizer {
        private final String[] tokens = new String[]{"cat"};

        public TestTokenizer2() {
            super(null);
        }

        @Override
        public String[] getTokens() {
            return this.tokens;
        }

        public Tokenizer create(Reader input) {
            return this;
        }
    }

    public static class TestTokenizer1
    extends TestTokenizer {
        private final String[] tokens = new String[]{"dog"};

        public TestTokenizer1() {
            super(null);
        }

        @Override
        public String[] getTokens() {
            return this.tokens;
        }

        public Tokenizer create(Reader input) {
            return this;
        }
    }
}

