/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import junit.framework.Assert;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.batchindexing.AncientBook;
import org.hibernate.search.test.batchindexing.Book;
import org.hibernate.search.test.batchindexing.Nation;

public class AvoidDuplicatesTest
extends SearchTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Nation italy = new Nation("Italy", "IT");
        session.persist((Object)italy);
        AncientBook aeneid = new AncientBook();
        aeneid.setTitle("Aeneid");
        aeneid.getAlternativeTitles().add("Aeneis");
        aeneid.getAlternativeTitles().add("Eneide");
        aeneid.setFirstPublishedIn(italy);
        session.persist((Object)aeneid);
        AncientBook commedia = new AncientBook();
        commedia.setTitle("Commedia");
        commedia.getAlternativeTitles().add("La Commedia");
        commedia.getAlternativeTitles().add("La Divina Commedia");
        commedia.setFirstPublishedIn(italy);
        session.persist((Object)commedia);
        transaction.commit();
        session.close();
    }

    public void testReindexedOnce() throws InterruptedException {
        Assert.assertEquals((int)2, (int)this.countBooksInIndex());
        Session session = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        MassIndexer massIndexer = fullTextSession.createIndexer(new Class[0]);
        massIndexer.startAndWait();
        session.close();
        Assert.assertEquals((int)2, (int)this.countBooksInIndex());
    }

    private int countBooksInIndex() {
        Session session = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        fullTextSession.beginTransaction();
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]);
        int size = fullTextQuery.list().size();
        fullTextSession.getTransaction().commit();
        fullTextSession.close();
        return size;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{AncientBook.class, Book.class, Nation.class};
    }
}

