/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.util.Properties;
import org.hibernate.search.SearchException;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationParseHelperTest {
    @Test
    public void testIntegerParsers() {
        Assert.assertEquals((long)0L, (long)ConfigurationParseHelper.parseInt((String)"   0 ", (String)"not important"));
        Assert.assertEquals((long)8L, (long)ConfigurationParseHelper.parseInt(null, (int)8, null));
        Assert.assertEquals((long)56L, (long)ConfigurationParseHelper.parseInt((String)"56", (int)8, null));
        Properties props = new Properties();
        props.setProperty("value1", "58");
        Assert.assertEquals((long)58L, (long)ConfigurationParseHelper.getIntValue((Properties)props, (String)"value1", (int)8));
        Assert.assertEquals((long)8L, (long)ConfigurationParseHelper.getIntValue((Properties)props, (String)"value2", (int)8));
        props.setProperty("value2", "nand");
        boolean exceptionLaunched = false;
        try {
            ConfigurationParseHelper.getIntValue((Properties)props, (String)"value2", (int)8);
        }
        catch (SearchException e) {
            exceptionLaunched = true;
        }
        Assert.assertTrue((boolean)exceptionLaunched);
    }

    @Test
    public void testBooleanParsers() {
        Assert.assertTrue((boolean)ConfigurationParseHelper.parseBoolean((String)"true", null));
        Assert.assertTrue((boolean)ConfigurationParseHelper.parseBoolean((String)" True ", null));
        Assert.assertFalse((boolean)ConfigurationParseHelper.parseBoolean((String)"false", null));
        Assert.assertFalse((boolean)ConfigurationParseHelper.parseBoolean((String)" False  ", null));
        boolean exceptionLaunched = false;
        try {
            ConfigurationParseHelper.parseBoolean((String)"5", (String)"error");
        }
        catch (SearchException e) {
            exceptionLaunched = true;
        }
        Assert.assertTrue((boolean)exceptionLaunched);
        exceptionLaunched = false;
        try {
            ConfigurationParseHelper.parseBoolean(null, (String)"error");
        }
        catch (SearchException e) {
            exceptionLaunched = true;
        }
        Assert.assertTrue((boolean)exceptionLaunched);
    }
}

