/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.Key;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.filter.StandardFilterKey;

public class SecurityFilterFactory {
    private static final long serialVersionUID = -19238668272676998L;
    private String ownerName;

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Factory
    public Filter buildSecurityFilter() {
        SecurityFilter securityFilter = new SecurityFilter(this.ownerName);
        return new CachingWrapperFilter((Filter)securityFilter);
    }

    @Key
    public FilterKey getKey() {
        StandardFilterKey key = new StandardFilterKey();
        key.addParameter((Object)this.ownerName);
        return key;
    }

    private static final class SecurityFilter
    extends Filter {
        private static final long serialVersionUID = -5105989141875576599L;
        private final String ownerName;

        private SecurityFilter(String ownerName) {
            this.ownerName = ownerName;
        }

        public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
            OpenBitSet bitSet = new OpenBitSet((long)reader.maxDoc());
            TermDocs termDocs = reader.termDocs(new Term("owner", this.ownerName));
            while (termDocs.next()) {
                bitSet.set((long)termDocs.doc());
            }
            return bitSet;
        }
    }
}

