/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.nullindexed;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.embedded.nullindexed.Man;
import org.hibernate.search.test.embedded.nullindexed.Pet;
import org.hibernate.search.test.embedded.nullindexed.Puppy;
import org.hibernate.search.test.embedded.nullindexed.Woman;

public class NullEmbeddedTest
extends SearchTestCase {
    public void testEmbeddedNullNotIndexedQuery() throws Exception {
        Man withoutPuppies = new Man("Davide");
        withoutPuppies.setPartner(null);
        Pet dog = new Pet("dog");
        dog.setPuppies(null);
        withoutPuppies.setPet(dog);
        Man wihKittens = new Man("Omar");
        Pet cat = new Pet("cat");
        wihKittens.setPet(cat);
        Puppy kittenOne = new Puppy("kitten one");
        Puppy KittenTwo = new Puppy("kitten two");
        cat.addPuppy(kittenOne).addPuppy(KittenTwo);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)withoutPuppies);
        s.persist((Object)wihKittens);
        s.persist((Object)dog);
        s.persist((Object)cat);
        s.persist((Object)kittenOne);
        s.persist((Object)KittenTwo);
        tx.commit();
        try {
            this.findNullsFor(s, "partner", "indexAsNull not set");
            NullEmbeddedTest.fail((String)"Embedded null field should not exists for field without indexAsNull property");
        }
        catch (SearchException e) {
            // empty catch block
        }
        s.clear();
        tx = s.beginTransaction();
        s.delete(s.get(Man.class, (Serializable)withoutPuppies.getId()));
        s.delete(s.get(Man.class, (Serializable)wihKittens.getId()));
        s.delete(s.get(Pet.class, (Serializable)dog.getId()));
        s.delete(s.get(Pet.class, (Serializable)cat.getId()));
        s.delete(s.get(Puppy.class, (Serializable)kittenOne.getId()));
        s.delete(s.get(Puppy.class, (Serializable)KittenTwo.getId()));
        tx.commit();
        s.close();
    }

    public void testNestedEmebeddedNullIndexing() throws Exception {
        Man withPet = new Man("Davide");
        Pet dog = new Pet("dog");
        dog.setPuppies(null);
        withPet.setPet(dog);
        Man withPuppies = new Man("Omar");
        Pet cat = new Pet("cat");
        withPuppies.setPet(cat);
        Puppy puppy1 = new Puppy("puppy one");
        Puppy puppy2 = new Puppy("puppy two");
        cat.addPuppy(puppy1).addPuppy(puppy2);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)withPet);
        s.persist((Object)withPuppies);
        s.persist((Object)dog);
        s.persist((Object)cat);
        s.persist((Object)puppy1);
        s.persist((Object)puppy2);
        tx.commit();
        List<Man> result = this.findNullsFor(s, "pet.puppies", "_null_");
        NullEmbeddedTest.assertEquals((String)"Wrong number of results found", (int)1, (int)result.size());
        NullEmbeddedTest.assertEquals((String)"Wrong result returned", (Object)withPet, (Object)result.get(0));
        s.clear();
        tx = s.beginTransaction();
        s.delete(s.get(Man.class, (Serializable)withPet.getId()));
        s.delete(s.get(Man.class, (Serializable)withPuppies.getId()));
        s.delete(s.get(Pet.class, (Serializable)dog.getId()));
        s.delete(s.get(Pet.class, (Serializable)cat.getId()));
        s.delete(s.get(Puppy.class, (Serializable)puppy1.getId()));
        s.delete(s.get(Puppy.class, (Serializable)puppy2.getId()));
        tx.commit();
        s.close();
    }

    public void testEmbeddedNullIndexing() throws Exception {
        Man me = new Man("Davide");
        Pet dog = new Pet("dog");
        me.setPet(null);
        Man someoneElse = new Man("Omar");
        Pet cat = new Pet("cat");
        someoneElse.setPet(cat);
        Puppy puppy1 = new Puppy("puppy one");
        Puppy puppy2 = new Puppy("puppy two");
        cat.addPuppy(puppy1).addPuppy(puppy2);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)me);
        s.persist((Object)someoneElse);
        s.persist((Object)dog);
        s.persist((Object)cat);
        s.persist((Object)puppy1);
        s.persist((Object)puppy2);
        tx.commit();
        List<Man> result = this.findNullsFor(this.getSession(), "pet", "NO_PET");
        NullEmbeddedTest.assertEquals((String)"Wrong number of results found", (int)1, (int)result.size());
        NullEmbeddedTest.assertEquals((String)"Wrong result returned", (Object)me, (Object)result.get(0));
        s.clear();
        tx = s.beginTransaction();
        s.delete(s.get(Man.class, (Serializable)me.getId()));
        s.delete(s.get(Man.class, (Serializable)someoneElse.getId()));
        s.delete(s.get(Pet.class, (Serializable)dog.getId()));
        s.delete(s.get(Pet.class, (Serializable)cat.getId()));
        s.delete(s.get(Puppy.class, (Serializable)puppy1.getId()));
        s.delete(s.get(Puppy.class, (Serializable)puppy2.getId()));
        tx.commit();
        s.close();
    }

    private List<Man> findNullsFor(Session s, String fieldName, String value) {
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryBuilder queryBuilder = session.getSearchFactory().buildQueryBuilder().forEntity(Man.class).get();
        Query query = ((TermMatchingContext)queryBuilder.keyword().onField(fieldName).ignoreAnalyzer()).matching((Object)value).createQuery();
        List result = session.createFullTextQuery(query, new Class[0]).list();
        return result;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Man.class, Pet.class, Puppy.class, Woman.class};
    }
}

