/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.indexapi;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.test.engine.indexapi.Leave;

@Entity
@Indexed
public class Tree {
    @Id
    @GeneratedValue
    private long id;
    @Field
    private String species;
    @OneToMany(mappedBy="tree", cascade={CascadeType.ALL})
    @IndexedEmbedded
    private Set<Leave> leaves;

    Tree() {
    }

    public Tree(String species) {
        this.species = species;
        this.leaves = new HashSet<Leave>();
    }

    public String getSpecies() {
        return this.species;
    }

    public Set<Leave> getLeaves() {
        return this.leaves;
    }

    public void growNewLeave() {
        this.leaves.add(new Leave());
    }
}

