/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;

public class SortTest
extends SearchTestCase {
    private static FullTextSession fullTextSession;
    private static QueryParser queryParser;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        fullTextSession = Search.getFullTextSession((Session)this.openSession());
        queryParser = new QueryParser(TestConstants.getTargetLuceneVersion(), "title", TestConstants.stopAnalyzer);
        this.createTestBooks();
        this.createTestNumbers();
    }

    @Override
    public void tearDown() throws Exception {
        if (!fullTextSession.getTransaction().isActive()) {
            this.deleteTestBooks();
            this.deleteTestNumbers();
            fullTextSession.close();
        }
        super.tearDown();
    }

    public void testResultOrderedById() throws Exception {
        Transaction tx = fullTextSession.beginTransaction();
        Query query = queryParser.parse("summary:lucene");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
        Sort sort = new Sort(new SortField("id", 3, false));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        SortTest.assertNotNull((Object)result);
        SortTest.assertEquals((String)"Wrong number of test results.", (int)3, (int)result.size());
        int id = 1;
        for (Book b : result) {
            SortTest.assertEquals((String)"Expected another id", (Object)id, (Object)b.getId());
            ++id;
        }
        tx.commit();
    }

    public void testResultOrderedBySummaryStringAscending() throws Exception {
        Transaction tx = fullTextSession.beginTransaction();
        Query query = queryParser.parse("summary:lucene OR summary:action");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
        Sort sort = new Sort(new SortField("summary_forSort", 3));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        SortTest.assertNotNull((Object)result);
        SortTest.assertEquals((String)"Wrong number of test results.", (int)4, (int)result.size());
        SortTest.assertEquals((String)"Groovy in Action", (String)((Book)result.get(0)).getSummary());
        tx.commit();
    }

    public void testResultOrderedBySummaryStringDescending() throws Exception {
        Transaction tx = fullTextSession.beginTransaction();
        Query query = queryParser.parse("summary:lucene OR summary:action");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
        Sort sort = new Sort(new SortField("summary_forSort", 3, true));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        SortTest.assertNotNull((Object)result);
        SortTest.assertEquals((String)"Wrong number of test results.", (int)4, (int)result.size());
        SortTest.assertEquals((String)"Hibernate & Lucene", (String)((Book)result.get(0)).getSummary());
        tx.commit();
    }

    public void testResultOrderedByDateDescending() throws Exception {
        Transaction tx = fullTextSession.beginTransaction();
        Query query = queryParser.parse("summary:lucene OR summary:action");
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
        Sort sort = new Sort(new SortField("publicationDate", 3, true));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        SortTest.assertNotNull((Object)result);
        SortTest.assertEquals((String)"Wrong number of test results.", (int)4, (int)result.size());
        for (Book book : result) {
            System.out.println(book.getSummary() + " : " + book.getPublicationDate());
        }
        SortTest.assertEquals((String)"Groovy in Action", (String)((Book)result.get(0)).getSummary());
        tx.commit();
    }

    public void testCustomFieldComparatorAscendingSort() {
        Transaction tx = fullTextSession.beginTransaction();
        MatchAllDocsQuery query = new MatchAllDocsQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery((Query)query, new Class[]{NumberHolder.class});
        Sort sort = new Sort(new SortField("sum", (FieldComparatorSource)new SumFieldComparatorSource()));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        SortTest.assertNotNull((Object)result);
        SortTest.assertEquals((String)"Wrong number of test results.", (int)4, (int)result.size());
        int previousSum = 0;
        for (NumberHolder n : result) {
            SortTest.assertTrue((String)"Documents should be ordered by increasing sum", (previousSum < n.getSum() ? 1 : 0) != 0);
            previousSum = n.getSum();
        }
        tx.commit();
    }

    public void testCustomFieldComparatorDescendingSort() {
        Transaction tx = fullTextSession.beginTransaction();
        MatchAllDocsQuery query = new MatchAllDocsQuery();
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery((Query)query, new Class[]{NumberHolder.class});
        Sort sort = new Sort(new SortField("sum", (FieldComparatorSource)new SumFieldComparatorSource(), true));
        hibQuery.setSort(sort);
        List result = hibQuery.list();
        SortTest.assertNotNull((Object)result);
        SortTest.assertEquals((String)"Wrong number of test results.", (int)4, (int)result.size());
        int previousSum = 100;
        for (NumberHolder n : result) {
            SortTest.assertTrue((String)"Documents should be ordered by decreasing sum", (previousSum > n.getSum() ? 1 : 0) != 0);
            previousSum = n.getSum();
        }
        tx.commit();
    }

    private void createTestBooks() {
        Transaction tx = fullTextSession.beginTransaction();
        Calendar cal = Calendar.getInstance();
        cal.set(2007, 6, 25, 11, 20, 30);
        Book book = new Book(1, "Hibernate & Lucene", "This is a test book.");
        book.setPublicationDate(cal.getTime());
        fullTextSession.save((Object)book);
        cal.add(13, 1);
        book = new Book(2, "Hibernate & Lucene", "This is a test book.");
        book.setPublicationDate(cal.getTime());
        fullTextSession.save((Object)book);
        cal.add(13, 1);
        book = new Book(3, "Hibernate & Lucene", "This is a test book.");
        book.setPublicationDate(cal.getTime());
        fullTextSession.save((Object)book);
        cal.add(13, 1);
        book = new Book(4, "Groovy in Action", "The bible of Groovy");
        book.setPublicationDate(cal.getTime());
        fullTextSession.save((Object)book);
        tx.commit();
        fullTextSession.clear();
    }

    private void createTestNumbers() {
        Transaction tx = fullTextSession.beginTransaction();
        NumberHolder holder = new NumberHolder(1, 1);
        fullTextSession.save((Object)holder);
        holder = new NumberHolder(1, 10);
        fullTextSession.save((Object)holder);
        holder = new NumberHolder(1, 5);
        fullTextSession.save((Object)holder);
        holder = new NumberHolder(3, 2);
        fullTextSession.save((Object)holder);
        tx.commit();
        fullTextSession.clear();
    }

    private void deleteTestBooks() {
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.createQuery("delete " + Book.class.getName()).executeUpdate();
        tx.commit();
        fullTextSession.clear();
    }

    private void deleteTestNumbers() {
        Transaction tx = fullTextSession.beginTransaction();
        fullTextSession.createQuery("delete " + NumberHolder.class.getName()).executeUpdate();
        tx.commit();
        fullTextSession.clear();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, Author.class, NumberHolder.class};
    }

    public static class SumFieldComparator
    extends FieldComparator<Integer> {
        private final String field1;
        private final String field2;
        private final int[] field1Values;
        private final int[] field2Values;
        private int[] currentReaderValuesField1;
        private int[] currentReaderValuesField2;
        private int bottom;

        public SumFieldComparator(int numHits, String field1, String field2) {
            this.field1 = field1;
            this.field2 = field2;
            this.field1Values = new int[numHits];
            this.field2Values = new int[numHits];
        }

        public int compare(int slot1, int slot2) {
            int v1 = this.field1Values[slot1] + this.field2Values[slot1];
            int v2 = this.field1Values[slot2] + this.field2Values[slot2];
            return this.compareValues(v1, v2);
        }

        private int compareValues(int v1, int v2) {
            if (v1 > v2) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }

        public int compareBottom(int doc) {
            int v = this.currentReaderValuesField1[doc] + this.currentReaderValuesField2[doc];
            return this.compareValues(this.bottom, v);
        }

        public void copy(int slot, int doc) {
            int v2;
            int v1;
            this.field1Values[slot] = v1 = this.currentReaderValuesField1[doc];
            this.field2Values[slot] = v2 = this.currentReaderValuesField2[doc];
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.currentReaderValuesField1 = FieldCache.DEFAULT.getInts(reader, this.field1, FieldCache.DEFAULT_INT_PARSER, false);
            this.currentReaderValuesField2 = FieldCache.DEFAULT.getInts(reader, this.field2, FieldCache.DEFAULT_INT_PARSER, false);
        }

        public void setBottom(int bottom) {
            this.bottom = this.field1Values[bottom] + this.field2Values[bottom];
        }

        public Integer value(int slot) {
            return this.field1Values[slot] + this.field2Values[slot];
        }
    }

    public static class SumFieldComparatorSource
    extends FieldComparatorSource {
        public FieldComparator<?> newComparator(String fieldName, int numHits, int sortPos, boolean reversed) throws IOException {
            return new SumFieldComparator(numHits, "num1", "num2");
        }
    }

    @Entity
    @Indexed
    public static class NumberHolder {
        @Id
        @GeneratedValue
        int id;
        @Field(analyze=Analyze.NO)
        int num1;
        @Field(analyze=Analyze.NO)
        int num2;

        public NumberHolder(int num1, int num2) {
            this.num1 = num1;
            this.num2 = num2;
        }

        public int getSum() {
            return this.num1 + this.num2;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("NumbersHolder");
            sb.append("{id=").append(this.id);
            sb.append(", num1=").append(this.num1);
            sb.append(", num2=").append(this.num2);
            sb.append('}');
            return sb.toString();
        }

        private NumberHolder() {
        }
    }
}

