/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.analysis.StopAnalyzer;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.util.ServiceRegistryTools;
import org.hibernate.search.util.impl.FileHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.testing.cache.CachingRegionFactory;

public class FullTextSessionBuilder {
    private static final Log log = LoggerFactory.make();
    private File indexRootDirectory;
    private final Properties cfg = new Properties();
    private final Set<Class<?>> annotatedClasses = new HashSet();
    private SessionFactory sessionFactory;
    private boolean usingFileSystem = false;
    private final List<LoadEventListener> additionalLoadEventListeners = new ArrayList<LoadEventListener>();

    public FullTextSessionBuilder() {
        this.cfg.setProperty("hibernate.search.lucene_version", TestConstants.getTargetLuceneVersion().name());
        this.cfg.setProperty("hibernate.hbm2ddl.auto", "create-drop");
        this.cfg.setProperty("hibernate.cache.use_second_level_cache", "true");
        this.cfg.setProperty("hibernate.cache.region.factory_class", CachingRegionFactory.class.getCanonicalName());
        this.cfg.setProperty("hibernate.cache.use_query_cache", "true");
        this.cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
        this.cfg.setProperty("hibernate.search.default.directory_provider", "ram");
        this.usingFileSystem = false;
    }

    public FullTextSessionBuilder useFileSystemDirectoryProvider(Class<?> testClass) {
        this.indexRootDirectory = new File(TestConstants.getIndexDirectory(testClass));
        log.debugf("Using %s as index directory.", (Object)this.indexRootDirectory.getAbsolutePath());
        this.cfg.setProperty("hibernate.search.default.directory_provider", "filesystem");
        this.cfg.setProperty("hibernate.search.default.indexBase", this.indexRootDirectory.getAbsolutePath());
        this.usingFileSystem = true;
        return this;
    }

    public FullTextSessionBuilder setProperty(String key, String value) {
        this.cfg.setProperty(key, value);
        return this;
    }

    public FullTextSessionBuilder addAnnotatedClass(Class annotatedClass) {
        this.annotatedClasses.add(annotatedClass);
        return this;
    }

    public FullTextSession openFullTextSession() {
        if (this.sessionFactory == null) {
            this.build();
        }
        Session session = this.sessionFactory.openSession();
        return Search.getFullTextSession((Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("sessionFactory not yet built");
        }
        try {
            this.sessionFactory.close();
        }
        finally {
            if (this.usingFileSystem) {
                this.cleanupFilesystem();
            }
        }
        this.sessionFactory = null;
    }

    public FullTextSessionBuilder build() {
        Configuration hibConfiguration = new Configuration();
        for (Class<?> annotatedClass : this.annotatedClasses) {
            hibConfiguration.addAnnotatedClass(annotatedClass);
        }
        hibConfiguration.getProperties().putAll((Map<?, ?>)this.cfg);
        ServiceRegistryBuilder registryBuilder = new ServiceRegistryBuilder();
        registryBuilder.applySettings((Map)hibConfiguration.getProperties());
        ServiceRegistry serviceRegistry = ServiceRegistryTools.build(registryBuilder);
        SessionFactoryImpl sessionFactoryImpl = (SessionFactoryImpl)hibConfiguration.buildSessionFactory(serviceRegistry);
        ServiceRegistryImplementor serviceRegistryImplementor = sessionFactoryImpl.getServiceRegistry();
        EventListenerRegistry registry = (EventListenerRegistry)serviceRegistryImplementor.getService(EventListenerRegistry.class);
        for (LoadEventListener listener : this.additionalLoadEventListeners) {
            registry.getEventListenerGroup(EventType.LOAD).appendListener((Object)listener);
        }
        this.sessionFactory = sessionFactoryImpl;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchFactory getSearchFactory() {
        FullTextSession fullTextSession = this.openFullTextSession();
        try {
            SearchFactory searchFactory = fullTextSession.getSearchFactory();
            return searchFactory;
        }
        finally {
            fullTextSession.close();
        }
    }

    public SearchMapping fluentMapping() {
        SearchMapping mapping = (SearchMapping)this.cfg.get("hibernate.search.model_mapping");
        if (mapping == null) {
            mapping = new SearchMapping();
            this.cfg.put("hibernate.search.model_mapping", mapping);
        }
        return mapping;
    }

    public void cleanupFilesystem() {
        FileHelper.delete((File)this.indexRootDirectory);
    }

    public FullTextSessionBuilder addLoadEventListener(LoadEventListener additionalLoadEventListener) {
        this.additionalLoadEventListeners.add(additionalLoadEventListener);
        return this;
    }
}

