/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend;

import java.util.Map;
import org.hibernate.search.backend.impl.lucene.WorkspaceHolder;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.backend.Clock;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class WorkQueueLengthConfiguredTest
extends SearchTestBase {
    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Clock.class};
    }

    @Test
    public void testNothingTest() {
        SearchIntegrator searchFactory = (SearchIntegrator)this.getSearchFactory().unwrap(SearchIntegrator.class);
        EntityIndexBinding indexBindingForEntity = searchFactory.getIndexBinding(Clock.class);
        IndexManager[] indexManagers = indexBindingForEntity.getIndexManagers();
        Assert.assertEquals((long)1L, (long)indexManagers.length);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexManagers[0];
        WorkspaceHolder backend = indexManager.getWorkspaceHolder();
        Assert.assertEquals((long)5L, (long)backend.getIndexResources().getMaxQueueLength());
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.max_queue_length", "5");
    }
}

