/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.optimizations;

import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.testsupport.backend.LeakingLocalBackend;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.optimizer.LeakingOptimizer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class UpdateOperationsTest {
    @Test
    public void testBackendOperationsCount() {
        this.invokeTest(true, 2);
    }

    @Test
    public void testDisablingOptimization() {
        this.invokeTest(false, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeTest(boolean indexMetadataIsComplete, int expectedBackendOperations) {
        try (FullTextSessionBuilder fullTextSessionBuilder = UpdateOperationsTest.createSearchFactory(indexMetadataIsComplete);){
            LeakingOptimizer.reset();
            LeakingLocalBackend.reset();
            FullTextSession session = fullTextSessionBuilder.openFullTextSession();
            Assert.assertEquals((long)0L, (long)LeakingOptimizer.getTotalOperations());
            Transaction tx = session.beginTransaction();
            session.persist((Object)new Document("The Book", "many paper pages assembled together at one side", "[old language you don't understand]"));
            tx.commit();
            Assert.assertEquals((long)1L, (long)LeakingOptimizer.getTotalOperations());
            Assert.assertEquals((long)1L, (long)LeakingLocalBackend.getLastProcessedQueue().size());
            tx = session.beginTransaction();
            List list = session.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]).list();
            Document doc = (Document)list.get(0);
            doc.setSummary("Example of what was used in ancient times to read");
            tx.commit();
            Assert.assertEquals((long)1L, (long)LeakingLocalBackend.getLastProcessedQueue().size());
            Assert.assertEquals((long)expectedBackendOperations, (long)LeakingOptimizer.getTotalOperations());
        }
    }

    private static FullTextSessionBuilder createSearchFactory(boolean indexMetadataIsComplete) {
        FullTextSessionBuilder builder = new FullTextSessionBuilder().setProperty("hibernate.search.default.worker.backend", LeakingLocalBackend.class.getName()).setProperty("hibernate.search.default.optimizer.implementation", LeakingOptimizer.class.getCanonicalName()).addAnnotatedClass(Document.class);
        if (!indexMetadataIsComplete) {
            builder.setProperty("hibernate.search.default.index_metadata_complete", "false");
        }
        return builder.build();
    }
}

