/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.interceptor;

import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.interceptor.IndexingOverride;
import org.hibernate.search.test.interceptor.Blog;
import org.hibernate.search.test.interceptor.BlogStatus;

public class IndexWhenPublishedInterceptor
implements EntityIndexingInterceptor<Blog> {
    public IndexingOverride onAdd(Blog entity) {
        if (entity.getStatus() == BlogStatus.PUBLISHED) {
            return IndexingOverride.APPLY_DEFAULT;
        }
        return IndexingOverride.SKIP;
    }

    public IndexingOverride onUpdate(Blog entity) {
        if (entity.getStatus() == BlogStatus.PUBLISHED) {
            return IndexingOverride.UPDATE;
        }
        return IndexingOverride.REMOVE;
    }

    public IndexingOverride onDelete(Blog entity) {
        return IndexingOverride.APPLY_DEFAULT;
    }

    public IndexingOverride onCollectionUpdate(Blog entity) {
        return this.onUpdate(entity);
    }
}

