/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.CalendarDay;
import org.hibernate.search.test.query.Employee;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.readerprovider.FieldSelectorLeakingReaderProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class LuceneProjectionQueryTest
extends SearchTestBase {
    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.default.directory_provider", "ram");
        cfg.put("hibernate.search.default.reader.strategy", FieldSelectorLeakingReaderProvider.class.getName());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Employee e1 = new Employee(1000, "Griffin", "ITech");
        s.save((Object)e1);
        Employee e2 = new Employee(1001, "Jackson", "Accounting");
        e2.setHireDate(new Date());
        s.save((Object)e2);
        Employee e3 = new Employee(1002, "Jimenez", "ITech");
        s.save((Object)e3);
        Employee e4 = new Employee(1003, "Stejskal", "ITech");
        s.save((Object)e4);
        Employee e5 = new Employee(1004, "Whetbrook", "ITech");
        s.save((Object)e5);
        s.persist((Object)new CalendarDay().setDayFromItalianString("01/04/2011"));
        s.persist((Object)new CalendarDay().setDayFromItalianString("02/04/2011"));
        tx.commit();
        s.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @After
    public void tearDown() throws Exception {
        try (Session s = this.getSession();){
            Transaction tx = s.beginTransaction();
            for (Object element : s.createQuery("from " + Employee.class.getName()).list()) {
                s.delete(element);
            }
            tx.commit();
        }
        super.tearDown();
    }

    @Test
    public void testProjectionOfThisFieldSelector() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.getSession());
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"__HSearch_This"});
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        FieldSelectorLeakingReaderProvider.assertFieldSelectorEnabled((String[])new String[]{"id"});
        tx.commit();
    }

    @Test
    public void testClassProjectionFieldSelector() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.getSession());
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"_hibernate_class"});
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        FieldSelectorLeakingReaderProvider.assertFieldSelectorEnabled((String[])new String[0]);
        tx.commit();
    }

    @Test
    public void testStoredFieldProjectionFieldSelector() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.getSession());
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"id", "lastname", "dept"});
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        FieldSelectorLeakingReaderProvider.assertFieldSelectorEnabled((String[])new String[]{"lastname", "dept", "id"});
        tx.commit();
    }

    @Test
    public void testLuceneDocumentProjection() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.getSession());
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:Accounting");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"__HSearch_Document"});
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Object[] projection = (Object[])result.get(0);
        Assert.assertTrue((String)"DOCUMENT incorrect", (boolean)(projection[0] instanceof Document));
        Assert.assertEquals((String)"DOCUMENT size incorrect", (long)5L, (long)((Document)projection[0]).getFields().size());
        tx.commit();
    }

    @Test
    public void testLuceneDocumentProjectionFieldSelector() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.getSession());
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:Accounting");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"__HSearch_Document"});
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        FieldSelectorLeakingReaderProvider.assertFieldSelectorDisabled();
        tx.commit();
    }

    @Test
    public void testLuceneDocumentIdProjection() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.getSession());
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"__HSearch_DocumentId"});
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Object[] projection = (Object[])result.get(0);
        Assert.assertTrue((String)"DOCUMENT_ID incorrect", (boolean)(projection[0] instanceof Integer));
        tx.commit();
    }

    @Test
    public void testLuceneDocumentIdProjectionFieldSelector() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.getSession());
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:ITech");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"__HSearch_DocumentId"});
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        FieldSelectorLeakingReaderProvider.assertFieldSelectorDisabled();
        tx.commit();
    }

    @Test
    public void testLuceneDocumentProjectionNonLoadedFieldOptimization() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.getSession());
        Transaction tx = s.beginTransaction();
        QueryParser parser = new QueryParser("dept", TestConstants.standardAnalyzer);
        Query query = parser.parse("dept:Accounting");
        FullTextQuery hibQuery = s.createFullTextQuery(query, new Class[]{Employee.class});
        hibQuery.setProjection(new String[]{"__HSearch_id", "__HSearch_Document"});
        List result = hibQuery.list();
        Assert.assertNotNull((Object)result);
        Object[] projection = (Object[])result.get(0);
        Assert.assertNotNull((Object)projection);
        Assert.assertEquals((String)"id field name not projected", (Object)1001, (Object)projection[0]);
        Assert.assertEquals((String)"Document fields should not be lazy on DOCUMENT projection", (Object)"Jackson", (Object)((Document)projection[1]).getField("lastname").stringValue());
        Assert.assertEquals((String)"DOCUMENT size incorrect", (long)5L, (long)((Document)projection[1]).getFields().size());
        tx.commit();
    }

    @Test
    public void testProjectionUnmappedFieldValues() throws ParseException, IOException {
        FullTextSession s = Search.getFullTextSession((Session)this.getSession());
        Transaction tx = s.beginTransaction();
        FullTextQuery hibQuery = s.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{CalendarDay.class});
        hibQuery.setProjection(new String[]{"day.year"});
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        List result = hibQuery.list();
        FieldSelectorLeakingReaderProvider.assertFieldSelectorEnabled((String[])new String[0]);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
        tx.commit();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Employee.class, CalendarDay.class};
    }
}

