/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.mariadb;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.ByteOrder;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkb;
import org.geolatte.geom.codec.WkbDecoder;
import org.geolatte.geom.codec.WkbEncoder;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class MariaDBGeometryTypeDescriptor
implements SqlTypeDescriptor {
    public static final MariaDBGeometryTypeDescriptor INSTANCE = new MariaDBGeometryTypeDescriptor();
    final WkbEncoder encoder = Wkb.newEncoder((Wkb.Dialect)Wkb.Dialect.MYSQL_WKB);
    final WkbDecoder decoder = Wkb.newDecoder((Wkb.Dialect)Wkb.Dialect.MYSQL_WKB);

    public int getSqlType() {
        return 2003;
    }

    public boolean canBeRemapped() {
        return false;
    }

    public <X> ValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                byte[] bytes = this.valueToByteArray(value, options);
                st.setBytes(index, bytes);
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                byte[] bytes = this.valueToByteArray(value, options);
                st.setBytes(name, bytes);
            }

            private byte[] valueToByteArray(X value, WrapperOptions options) {
                Geometry geometry = (Geometry)this.getJavaDescriptor().unwrap(value, Geometry.class, options);
                ByteBuffer buffer = MariaDBGeometryTypeDescriptor.this.encoder.encode(geometry, ByteOrder.NDR);
                return buffer == null ? null : buffer.toByteArray();
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap((Object)MariaDBGeometryTypeDescriptor.this.toGeometry(rs.getBytes(name)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap((Object)MariaDBGeometryTypeDescriptor.this.toGeometry(statement.getBytes(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap((Object)MariaDBGeometryTypeDescriptor.this.toGeometry(statement.getBytes(name)), options);
            }
        };
    }

    private Geometry<?> toGeometry(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.from((byte[])bytes);
        return this.decoder.decode(buffer);
    }
}

