/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.mapping.ForeignKey;

public abstract class AbstractDatabaseCollector
implements DatabaseCollector {
    private Map<String, List<ForeignKey>> oneToManyCandidates;
    protected final Map<TableIdentifier, String> suggestedIdentifierStrategies = new HashMap<TableIdentifier, String>();
    private MetaDataDialect metaDataDialect;

    public AbstractDatabaseCollector(MetaDataDialect metaDataDialect) {
        this.metaDataDialect = metaDataDialect;
    }

    @Override
    public void setOneToManyCandidates(Map<String, List<ForeignKey>> oneToManyCandidates) {
        this.oneToManyCandidates = oneToManyCandidates;
    }

    @Override
    public Map<String, List<ForeignKey>> getOneToManyCandidates() {
        return this.oneToManyCandidates;
    }

    @Override
    public String getSuggestedIdentifierStrategy(String catalog, String schema, String name) {
        TableIdentifier identifier = new TableIdentifier(catalog, schema, name);
        return this.suggestedIdentifierStrategies.get(identifier);
    }

    @Override
    public void addSuggestedIdentifierStrategy(String catalog, String schema, String name, String idstrategy) {
        TableIdentifier identifier = new TableIdentifier(catalog, schema, name);
        this.suggestedIdentifierStrategies.put(identifier, idstrategy);
    }

    protected String quote(String name) {
        if (name == null) {
            return name;
        }
        if (this.metaDataDialect.needQuote(name)) {
            if (name.length() > 1 && name.charAt(0) == '`' && name.charAt(name.length() - 1) == '`') {
                return name;
            }
            return "`" + name + "`";
        }
        return name;
    }
}

