/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.gmap;

import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.context.effects.JavascriptContext;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class GMap
extends UIPanel {
    public static final String COMPONENET_TYPE = "com.icesoft.faces.GMap";
    public static final String DEFAULT_RENDERER_TYPE = "com.icesoft.faces.GMapRenderer";
    private String DEFAULT_LONGITUDE = "-101.162109375";
    private String DEFAULT_LATITUDE = "56.46249048388979";
    private String longitude;
    private String latitude;
    private Integer zoomLevel;
    private Boolean locateAddress;
    private boolean initilized = false;
    private String address;
    private String type;
    private String style = null;
    private String styleClass = null;
    private String renderedOnUserRole = null;
    private boolean jsLibraryLoaded = false;

    public String getRendererType() {
        return DEFAULT_RENDERER_TYPE;
    }

    public String getComponentType() {
        return COMPONENET_TYPE;
    }

    public String getLongitude() {
        if (this.longitude != null) {
            return this.longitude;
        }
        ValueBinding vb = this.getValueBinding("longitude");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : this.DEFAULT_LONGITUDE;
    }

    public String getLatitude() {
        if (this.latitude != null) {
            return this.latitude;
        }
        ValueBinding vb = this.getValueBinding("latitude");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : this.DEFAULT_LATITUDE;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
        ValueBinding vb = this.getValueBinding("longitude");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)longitude);
            this.longitude = null;
        }
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
        ValueBinding vb = this.getValueBinding("latitude");
        if (vb != null) {
            vb.setValue(this.getFacesContext(), (Object)latitude);
            this.latitude = null;
        }
    }

    public void decode(FacesContext facesContext) {
        String clientId;
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        if (map.get((clientId = this.getClientId(facesContext)) + "event") != null && map.get(clientId + "event").toString().length() > 0) {
            if (map.containsKey(clientId + "lat")) {
                this.setLatitude(String.valueOf(map.get(clientId + "lat")));
            }
            if (map.containsKey(clientId + "lng")) {
                this.setLongitude(String.valueOf(map.get(clientId + "lng")));
            }
            if (map.containsKey(clientId + "zoom")) {
                this.setZoomLevel(Integer.valueOf(String.valueOf(map.get(clientId + "zoom"))));
            }
            if (map.containsKey(clientId + "type")) {
                this.setType(String.valueOf(map.get(clientId + "type")));
            }
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.loadJsLibrary(context);
        super.encodeBegin(context);
        if (context.getExternalContext().getRequestParameterMap() != null && context.getExternalContext().getRequestParameterMap().size() <= 1) {
            this.initilized = false;
        }
        if ((this.isLocateAddress() || !this.initilized) && this.getAddress() != null && this.getAddress().length() > 2) {
            JavascriptContext.addJavascriptCall((FacesContext)context, (String)("Ice.GoogleMap.locateAddress('" + this.getClientId(context) + "', '" + this.getAddress() + "');"));
            this.initilized = true;
        } else if (this.isLocatedByGeocoder(context)) {
            JavascriptContext.addJavascriptCall((FacesContext)context, (String)("Ice.GoogleMap.getGMapWrapper('" + this.getClientId(context) + "').getRealGMap().setZoom(" + this.getZoomLevel() + ");"));
        } else {
            String latitude = this.getLatitude();
            String longitude = this.getLongitude();
            try {
                Float.parseFloat(latitude);
                Float.parseFloat(longitude);
            }
            catch (NumberFormatException e) {
                latitude = this.DEFAULT_LATITUDE;
                longitude = this.DEFAULT_LONGITUDE;
            }
            JavascriptContext.addJavascriptCall((FacesContext)context, (String)("Ice.GoogleMap.getGMapWrapper('" + this.getClientId(context) + "').getRealGMap().setCenter(new GLatLng(" + latitude + ", " + longitude + "), " + this.getZoomLevel() + ");"));
        }
        JavascriptContext.addJavascriptCall((FacesContext)context, (String)("Ice.GoogleMap.setMapType('" + this.getClientId(context) + "', '" + this.getType() + "');"));
    }

    private void loadJsLibrary(FacesContext context) {
        if (this.jsLibraryLoaded) {
            return;
        }
        String key = context.getCurrentInstance().getExternalContext().getInitParameter("com.icesoft.faces.gmapKey");
        if (key != null) {
            JavascriptContext.includeLib((String)("http://maps.google.com/maps?file=api&v=2&key=" + key), (FacesContext)FacesContext.getCurrentInstance());
            this.jsLibraryLoaded = true;
        }
    }

    public int getZoomLevel() {
        if (this.zoomLevel != null) {
            return this.zoomLevel;
        }
        ValueBinding vb = this.getValueBinding("zoomLevel");
        return vb != null ? (Integer)vb.getValue(this.getFacesContext()) : 3;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = new Integer(zoomLevel);
    }

    private boolean isLocatedByGeocoder(FacesContext context) {
        Object event = context.getExternalContext().getRequestParameterMap().get(this.getClientId(context) + "event");
        return event != null && "geocoder".equals(event);
    }

    public boolean isLocateAddress() {
        if (this.locateAddress != null) {
            return this.locateAddress;
        }
        ValueBinding vb = this.getValueBinding("locateAddress");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setLocateAddress(boolean locateAddress) {
        this.locateAddress = new Boolean(locateAddress);
    }

    public String getAddress() {
        if (this.address != null) {
            return this.address;
        }
        ValueBinding vb = this.getValueBinding("address");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getType() {
        if (this.type != null) {
            return this.type;
        }
        ValueBinding vb = this.getValueBinding("type");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "Map";
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRenderedOnUserRole(String renderedOnUserRole) {
        this.renderedOnUserRole = renderedOnUserRole;
    }

    public String getRenderedOnUserRole() {
        if (this.renderedOnUserRole != null) {
            return this.renderedOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("renderedOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public boolean isRendered() {
        if (!Util.isRenderedOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "border-collapse:collapse; border-spacing:0px; padding:0px;";
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "iceGmp", "styleClass");
    }

    public String getMapTdStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "MapTd");
    }

    public String getTxtTdStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "TxtTd");
    }
}

