/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputrichtext;

import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.context.JarResource;
import com.icesoft.faces.context.Resource;
import com.icesoft.faces.context.ResourceLinker;
import com.icesoft.faces.context.ResourceRegistry;
import com.icesoft.faces.util.CoreUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class InputRichText
extends UIInput {
    public static final String COMPONENET_TYPE = "com.icesoft.faces.InputRichText";
    public static final String DEFAULT_RENDERER_TYPE = "com.icesoft.faces.InputRichTextRenderer";
    private static final Resource ICE_FCK_EDITOR_JS = new JarResource("com/icesoft/faces/component/inputrichtext/fckeditor_ext.js");
    private static final Resource FCK_EDITOR_JS = new JarResource("com/icesoft/faces/component/inputrichtext/fckeditor.js");
    private static final String FCK_EDITOR_ZIP = "com/icesoft/faces/component/inputrichtext/fckeditor.zip";
    private static final Date lastModified = new Date();
    private static final Map ZipEntryCache = new HashMap();
    private static final ResourceLinker.Handler FCK_LINKED_BASE;
    private String language;
    private String _for;
    private String style;
    private String styleClass;
    private String width;
    private String height;
    private static URI baseURI;
    private static Boolean exist;
    private String toolbar;
    private String customConfigPath;
    private Boolean disabled = null;
    private String skin = null;
    private Boolean saveOnSubmit = null;

    public static void loadFCKJSIfRequired() {
        ResourceRegistry registry;
        if (FacesContext.getCurrentInstance() != null && baseURI == null && exist.booleanValue() && (registry = (ResourceRegistry)FacesContext.getCurrentInstance()) != null) {
            baseURI = registry.loadJavascriptCode(FCK_EDITOR_JS, FCK_LINKED_BASE);
            registry.loadJavascriptCode(ICE_FCK_EDITOR_JS);
        }
    }

    public String getRendererType() {
        return DEFAULT_RENDERER_TYPE;
    }

    public String getComponentType() {
        return COMPONENET_TYPE;
    }

    public InputRichText() {
        baseURI = null;
        exist = Boolean.TRUE;
    }

    public void decode(FacesContext facesContext) {
        String clientId;
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        if (map.containsKey(clientId = this.getClientId(facesContext))) {
            String newValue = map.get(clientId).toString().replace('\n', ' ');
            this.setSubmittedValue(newValue);
        }
        super.decode(facesContext);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        if (this.language != null) {
            return this.language;
        }
        ValueBinding vb = this.getValueBinding("language");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "en";
    }

    public void setFor(String _for) {
        this._for = _for;
    }

    public String getFor() {
        if (this._for != null) {
            return this._for;
        }
        ValueBinding vb = this.getValueBinding("for");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "";
    }

    boolean isToolbarOnly() {
        return false;
    }

    public URI getBaseURI() {
        if (baseURI == null) {
            InputRichText.loadFCKJSIfRequired();
        }
        return baseURI;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "iceInpRchTxt", "styleClass");
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getWidth() {
        if (this.width != null) {
            return this.width;
        }
        ValueBinding vb = this.getValueBinding("width");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "100%";
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getHeight() {
        if (this.height != null) {
            return this.height;
        }
        ValueBinding vb = this.getValueBinding("height");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "200";
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int len = 0;
        while ((len = input.read(buf)) > -1) {
            output.write(buf, 0, len);
        }
        return output.toByteArray();
    }

    public void setToolbar(String toolbar) {
        this.toolbar = toolbar;
    }

    public String getToolbar() {
        if (this.toolbar != null) {
            return this.toolbar;
        }
        ValueBinding vb = this.getValueBinding("toolbar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "Default";
    }

    public void setCustomConfigPath(String customConfigPath) {
        this.customConfigPath = customConfigPath;
    }

    public String getCustomConfigPath() {
        if (this.customConfigPath != null) {
            return CoreUtils.resolveResourceURL((FacesContext)this.getFacesContext(), (String)this.customConfigPath);
        }
        ValueBinding vb = this.getValueBinding("customConfigPath");
        return vb != null ? CoreUtils.resolveResourceURL((FacesContext)this.getFacesContext(), (String)((String)vb.getValue(this.getFacesContext()))) : null;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = new Boolean(disabled);
    }

    public boolean isDisabled() {
        if (this.disabled != null) {
            return this.disabled;
        }
        ValueBinding vb = this.getValueBinding("disabled");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public String getSkin() {
        if (this.skin != null) {
            return this.skin;
        }
        ValueBinding vb = this.getValueBinding("skin");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "default";
    }

    public void setSaveOnSubmit(boolean saveOnSubmit) {
        this.saveOnSubmit = new Boolean(saveOnSubmit);
    }

    public boolean isSaveOnSubmit() {
        if (this.saveOnSubmit != null) {
            return this.saveOnSubmit;
        }
        ValueBinding vb = this.getValueBinding("saveOnSubmit");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    static {
        try {
            ZipEntry entry;
            InputStream in = InputRichText.class.getClassLoader().getResourceAsStream(FCK_EDITOR_ZIP);
            ZipInputStream zip = new ZipInputStream(in);
            while ((entry = zip.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                ZipEntryCache.put(entry.getName(), InputRichText.toByteArray(zip));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        FCK_LINKED_BASE = new ResourceLinker.Handler(){

            public void linkWith(ResourceLinker linker) {
                Iterator i = ZipEntryCache.keySet().iterator();
                while (i.hasNext()) {
                    final String entryName = (String)i.next();
                    linker.registerRelativeResource(entryName, new Resource(){

                        public String calculateDigest() {
                            return String.valueOf(InputRichText.FCK_EDITOR_ZIP + entryName);
                        }

                        public Date lastModified() {
                            return lastModified;
                        }

                        public InputStream open() throws IOException {
                            return new ByteArrayInputStream((byte[])ZipEntryCache.get(entryName));
                        }

                        public void withOptions(Resource.Options options) {
                            options.setFileName(entryName);
                            options.setLastModified(lastModified);
                        }
                    });
                }
            }
        };
        baseURI = null;
        exist = Boolean.FALSE;
    }
}

