/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.panelpositioned;

import com.icesoft.faces.component.panelpositioned.PanelPositioned;
import com.icesoft.faces.component.panelpositioned.PanelPositionedEvent;
import com.icesoft.faces.component.panelpositioned.PanelPositionedModel;
import com.icesoft.faces.component.panelpositioned.PanelPositionedValue;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.EffectsArguments;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.utils.DnDCache;
import java.beans.Beans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class PanelPositionedRenderer
extends DomBasicRenderer {
    private static Log log = LogFactory.getLog((Class)PanelPositionedRenderer.class);
    private static final String INPUT_ID = "colOrder";

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        try {
            Element root;
            DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
            if (!domContext.isInitialized()) {
                root = domContext.createRootElement("div");
                domContext.setRootNode((Node)root);
                PanelPositionedRenderer.setRootElementId((FacesContext)facesContext, (Element)root, (UIComponent)uiComponent);
                String style = ((PanelPositioned)uiComponent).getStyle();
                String styleClass = ((PanelPositioned)uiComponent).getStyleClass();
                if (style != null && style.length() > 0) {
                    root.setAttribute("style", style);
                } else {
                    root.removeAttribute("style");
                }
                if (styleClass != null && styleClass.length() > 0) {
                    root.setAttribute("class", styleClass);
                } else {
                    root.removeAttribute("class");
                }
                Element orderField = domContext.createElement("input");
                String orderFieldId = this.getHiddenFieldName(facesContext, uiComponent, INPUT_ID);
                orderField.setAttribute("id", orderFieldId);
                orderField.setAttribute("type", "hidden");
                orderField.setAttribute("name", orderFieldId);
                orderField.setAttribute("value", "");
                if (this.isChanged(facesContext)) {
                    Text node = domContext.createTextNode("<!-- " + new Random().nextInt(1000) + "-->");
                    root.appendChild(node);
                }
                root.appendChild(orderField);
            }
            root = (Element)domContext.getRootNode();
            if (!Beans.isDesignTime()) {
                DOMContext.removeChildrenByTagName((Element)root, (String)"div");
            }
            domContext.streamWrite(facesContext, uiComponent);
        }
        catch (Exception e) {
            log.error((Object)"Encode Begin", (Throwable)e);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        String id = uiComponent.getClientId(facesContext);
        PanelPositioned panelPositioned = (PanelPositioned)uiComponent;
        String orderFieldId = this.getHiddenFieldName(facesContext, uiComponent, INPUT_ID);
        EffectsArguments ea = new EffectsArguments();
        ea.add("tag", "div");
        String o = panelPositioned.getConstraint();
        if (o == null) {
            ea.add("constraint", false);
        } else {
            ea.add("constraint", panelPositioned.getConstraint());
        }
        ea.add("dropOnEmpty", true);
        ea.add("containment", false);
        o = panelPositioned.getHandle();
        if (o != null) {
            ea.add("handle", o);
        }
        if ((o = panelPositioned.getHoverclass()) != null) {
            ea.add("hoverclass", o);
        }
        if ((o = panelPositioned.getOverlap()) != null) {
            ea.add("overlap", o);
        }
        String updateCode = "function(){var o = Sortable.options('" + id + "');" + "var s = o.serializeValue;" + "f = $('" + orderFieldId + "');" + "f.value = s;" + "}";
        ea.addFunction("onUpdate", updateCode);
        if (!panelPositioned.isDisabled()) {
            String call = "Sortable.create('" + id + "'" + ea.toString();
            JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)call);
        }
        DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent).stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        try {
            this.validateParameters(facesContext, uiComponent, null);
            DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
            Element root = (Element)domContext.getRootNode();
            PanelPositioned series = (PanelPositioned)uiComponent;
            List seriesList = (List)series.getValueAsList();
            if (seriesList != null) {
                if (log.isTraceEnabled()) {
                    for (int i = 0; i < seriesList.size(); ++i) {
                        log.trace((Object)("Encode index[" + i + "] value [" + seriesList.get(i) + "]"));
                    }
                }
                Iterator cells = seriesList.iterator();
                int index = 0;
                PanelPositionedModel ppm = PanelPositionedModel.resetInstance(facesContext, uiComponent);
                while (cells.hasNext()) {
                    series.setRowIndex(index);
                    Object cell = cells.next();
                    Iterator childs = uiComponent.getChildren().iterator();
                    while (childs.hasNext()) {
                        UIComponent nextChild = (UIComponent)childs.next();
                        if (!nextChild.isRendered()) continue;
                        domContext.setCursorParent((Node)root);
                        domContext.streamWrite(facesContext, uiComponent, (Node)root, (Node)root);
                        PanelPositionedRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)nextChild);
                        String childId = nextChild.getClientId(facesContext);
                        ppm.setIndex(childId, index);
                        DnDCache.getInstance(facesContext, false).putPositionPanelValue(childId, seriesList, index);
                    }
                    ++index;
                }
                series.setRowIndex(-1);
            }
            domContext.setCursorParent((Node)root);
        }
        catch (Exception e) {
            log.error((Object)"Encode Children", (Throwable)e);
        }
    }

    public void decode(FacesContext context, UIComponent component) {
        try {
            super.decode(context, component);
            if (component instanceof PanelPositioned) {
                Map requestParameters = context.getExternalContext().getRequestParameterMap();
                PanelPositioned uiSeries = (PanelPositioned)component;
                PanelPositionedModel sortOrder = PanelPositionedModel.getInstance(context, component);
                String baseName = this.getHiddenFieldName(context, component, INPUT_ID);
                Iterator names = requestParameters.keySet().iterator();
                names = requestParameters.keySet().iterator();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    int lastIndex = -1;
                    if (!name.equals(baseName)) continue;
                    String value = (String)requestParameters.get(name);
                    StringTokenizer st = new StringTokenizer(value, ";");
                    Object o = uiSeries.getValueAsList();
                    ArrayList newList = new ArrayList();
                    List oldList = null;
                    if (!(o instanceof List)) {
                        throw new RuntimeException("PanelPositioned must have a java.util.List instance set as its value");
                    }
                    oldList = (List)o;
                    if (!st.hasMoreTokens()) continue;
                    st.nextToken();
                    String last = st.nextToken();
                    lastIndex = sortOrder.getIndex(last);
                    String s = st.nextToken();
                    int currentIndex = 0;
                    while (st.hasMoreTokens()) {
                        String id = st.nextToken();
                        int index = sortOrder.getIndex(id);
                        if (index != -1) {
                            Object obj = oldList.get(index);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("Moving ID[" + id + "] Value [" + obj.toString() + "] from index [" + index + "] to [" + currentIndex + "]"));
                            }
                            newList.add(obj);
                        } else {
                            PanelPositionedValue ppv = DnDCache.getInstance(context, false).getPositionedPanelValue(id);
                            if (ppv != null) {
                                List source = ppv.getSourceList();
                                Object sourceValue = source.get(ppv.getValueIndex());
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("Added value [" + sourceValue + "]"));
                                }
                                newList.add(sourceValue);
                            } else {
                                throw new RuntimeException("Unable to find Value for ID[" + id + "]");
                            }
                        }
                        ++currentIndex;
                    }
                    int[] eventInfo = this.getEventInfo(oldList, newList);
                    int event_type = eventInfo[0];
                    int newIndex = eventInfo[1];
                    int oldIndex = eventInfo[2];
                    if (event_type == PanelPositionedEvent.TYPE_MOVE && lastIndex != oldIndex) {
                        int a = newIndex;
                        newIndex = oldIndex;
                        oldIndex = a;
                    }
                    if (log.isTraceEnabled()) {
                        for (int i = 0; i < newList.size(); ++i) {
                            log.trace((Object)("New Index [" + i + "] Value [" + newList.get(i) + "]"));
                        }
                    }
                    this.setChanged(context);
                    uiSeries.queueEvent(new PanelPositionedEvent(component, uiSeries.getListener(), event_type, newIndex, oldIndex, oldList, newList));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Decode Error Positioned Panel ", (Throwable)e);
        }
    }

    private void setChanged(FacesContext context) {
        context.getExternalContext().getRequestMap().put(PanelPositionedRenderer.class.getName(), Boolean.TRUE);
    }

    private boolean isChanged(FacesContext context) {
        Boolean b = (Boolean)context.getExternalContext().getRequestMap().get(PanelPositionedRenderer.class.getName());
        return b != null && b != false;
    }

    private String getHiddenFieldName(FacesContext facesContext, UIComponent uiComponent, String name) {
        UIComponent form = PanelPositionedRenderer.findForm((UIComponent)uiComponent);
        if (form == null) {
            throw new NullPointerException("PanelPositioned must be contained withing an <ice:form>");
        }
        String formId = form.getClientId(facesContext);
        String clientId = uiComponent.getClientId(facesContext);
        return formId + ':' + "_id" + clientId + name;
    }

    private int[] getEventInfo(List l1, List l2) {
        int type;
        int newIndex = -1;
        int oldIndex = -1;
        if (l1.size() > l2.size()) {
            type = PanelPositionedEvent.TYPE_REMOVE;
        } else if (l1.size() < l2.size()) {
            type = PanelPositionedEvent.TYPE_ADD;
            List l = l1;
            l1 = l2;
            l2 = l;
        } else {
            type = PanelPositionedEvent.TYPE_MOVE;
            for (int i = 0; i < l1.size(); ++i) {
                if (l1.get(i) == l2.get(i)) continue;
                if (newIndex == -1) {
                    newIndex = i;
                    continue;
                }
                oldIndex = i;
            }
        }
        if (type != PanelPositionedEvent.TYPE_MOVE) {
            for (int i = 0; i < l1.size(); ++i) {
                if (l2.contains(l1.get(i))) continue;
                newIndex = i;
            }
        }
        return new int[]{type, newIndex, oldIndex};
    }
}

