/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.element;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.RandomUtil;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.ox.element.OpenPgpContentElement;
import org.jxmpp.jid.Jid;

public abstract class EncryptedOpenPgpContentElement
extends OpenPgpContentElement {
    public static final String ELEM_RPAD = "rpad";
    private final String rpad;

    protected EncryptedOpenPgpContentElement(Set<? extends Jid> to, String rpad, Date timestamp, List<ExtensionElement> payload) {
        super((Set)Objects.requireNonNullNorEmpty(to, (String)"Encrypted OpenPGP content elements must have at least one 'to' attribute."), timestamp, payload);
        this.rpad = (String)Objects.requireNonNull((Object)rpad);
    }

    protected EncryptedOpenPgpContentElement(Set<? extends Jid> to, List<ExtensionElement> payload) {
        super((Set)Objects.requireNonNullNorEmpty(to, (String)"Encrypted OpenPGP content elements must have at least one 'to' attribute."), new Date(), payload);
        this.rpad = EncryptedOpenPgpContentElement.createRandomPadding();
    }

    private static String createRandomPadding() {
        int len = RandomUtil.nextSecureRandomInt((int)256);
        return StringUtils.randomString((int)len);
    }

    @Override
    protected void addCommonXml(XmlStringBuilder xml) {
        super.addCommonXml(xml);
        xml.openElement(ELEM_RPAD).escape(this.rpad).closeElement(ELEM_RPAD);
    }
}

