package org.infinispan.jcache.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import javax.cache.configuration.Configuration;
import javax.cache.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import java.io.Closeable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.infinispan.jcache.logging.Log.LeakDescription;
import javax.cache.processor.EntryProcessorException;
import java.lang.NullPointerException;
import org.jboss.logging.BasicLogger;
import java.lang.ClassCastException;
import java.lang.Throwable;
import java.lang.Class;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-04-29T05:15:15-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String cacheManagerNotClosed = "ISPN021001: Allocation stack trace:";
    protected String cacheManagerNotClosed$str() {
        return cacheManagerNotClosed;
    }
    @Override
    public final LeakDescription cacheManagerNotClosed() {
        final LeakDescription result = new LeakDescription(String.format(getLoggingLocale(), cacheManagerNotClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void leakedCacheManager(final Throwable allocationStackTrace) {
        super.log.logf(FQCN, WARN, allocationStackTrace, leakedCacheManager$str());
    }
    private static final String leakedCacheManager = "ISPN021002: Closing leaked cache manager";
    protected String leakedCacheManager$str() {
        return leakedCacheManager;
    }
    private static final String methodWithoutCacheAnnotation = "ISPN021003: Method named '%s' is not annotated with CacheResult, CachePut, CacheRemoveEntry or CacheRemoveAll";
    protected String methodWithoutCacheAnnotation$str() {
        return methodWithoutCacheAnnotation;
    }
    @Override
    public final IllegalArgumentException methodWithoutCacheAnnotation(final String methodName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), methodWithoutCacheAnnotation$str(), methodName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cachePutMethodWithoutCacheValueParameter = "ISPN021004: Method named '%s' must have at least one parameter annotated with @CacheValue";
    protected String cachePutMethodWithoutCacheValueParameter$str() {
        return cachePutMethodWithoutCacheValueParameter;
    }
    @Override
    public final CacheException cachePutMethodWithoutCacheValueParameter(final String methodName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cachePutMethodWithoutCacheValueParameter$str(), methodName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cachePutMethodWithMoreThanOneCacheValueParameter = "ISPN021005: Method named '%s' must have only one parameter annotated with @CacheValue";
    protected String cachePutMethodWithMoreThanOneCacheValueParameter$str() {
        return cachePutMethodWithMoreThanOneCacheValueParameter;
    }
    @Override
    public final CacheException cachePutMethodWithMoreThanOneCacheValueParameter(final String methodName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cachePutMethodWithMoreThanOneCacheValueParameter$str(), methodName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheRemoveEntryMethodWithoutCacheName = "ISPN021006: Method named '%s' is annotated with CacheRemoveEntry but doesn't specify a cache name";
    protected String cacheRemoveEntryMethodWithoutCacheName$str() {
        return cacheRemoveEntryMethodWithoutCacheName;
    }
    @Override
    public final CacheException cacheRemoveEntryMethodWithoutCacheName(final String methodName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheRemoveEntryMethodWithoutCacheName$str(), methodName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheRemoveAllMethodWithoutCacheName = "ISPN021007: Method named '%s' is annotated with CacheRemoveAll but doesn't specify a cache name";
    protected String cacheRemoveAllMethodWithoutCacheName$str() {
        return cacheRemoveAllMethodWithoutCacheName;
    }
    @Override
    public final CacheException cacheRemoveAllMethodWithoutCacheName(final String methodName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheRemoveAllMethodWithoutCacheName$str(), methodName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInstantiateCacheKeyGenerator = "ISPN021008: Unable to instantiate CacheKeyGenerator with type '%s'";
    protected String unableToInstantiateCacheKeyGenerator$str() {
        return unableToInstantiateCacheKeyGenerator;
    }
    @Override
    public final CacheException unableToInstantiateCacheKeyGenerator(final Class<?> type, final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToInstantiateCacheKeyGenerator$str(), type), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parameterMustNotBeNull = "ISPN021010: '%s' parameter must not be null";
    protected String parameterMustNotBeNull$str() {
        return parameterMustNotBeNull;
    }
    @Override
    public final NullPointerException parameterMustNotBeNull(final String parameterName) {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), parameterMustNotBeNull$str(), parameterName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompatibleType = "ISPN021011: Incompatible cache value types specified, expected %s but %s was specified";
    protected String incompatibleType$str() {
        return incompatibleType;
    }
    @Override
    public final ClassCastException incompatibleType(final Class<?> type, final Class<?> cfgType) {
        final ClassCastException result = new ClassCastException(String.format(getLoggingLocale(), incompatibleType$str(), type, cfgType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheAlreadyRegistered = "ISPN021015: Cache %s already registered with configuration %s, and can not be registered again with a new given configuration %s";
    protected String cacheAlreadyRegistered$str() {
        return cacheAlreadyRegistered;
    }
    @Override
    public final CacheException cacheAlreadyRegistered(final String cacheName, final Configuration cacheCfg, final Configuration newCfg) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheAlreadyRegistered$str(), cacheName, cacheCfg, newCfg));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownExpiryOperation = "ISPN021016: Unknown expiry operation: %s";
    protected String unknownExpiryOperation$str() {
        return unknownExpiryOperation;
    }
    @Override
    public final IllegalStateException unknownExpiryOperation(final String op) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownExpiryOperation$str(), op));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String configurationClassNotSupported = "ISPN021018: The configuration class %s is not supported by this implementation";
    protected String configurationClassNotSupported$str() {
        return configurationClassNotSupported;
    }
    @Override
    public final IllegalArgumentException configurationClassNotSupported(final Class clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), configurationClassNotSupported$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String entryProcessingFailed = "ISPN021019: Entry processing failed";
    protected String entryProcessingFailed$str() {
        return entryProcessingFailed;
    }
    @Override
    public final EntryProcessorException entryProcessingFailed(final Throwable t) {
        final EntryProcessorException result = new EntryProcessorException(String.format(getLoggingLocale(), entryProcessingFailed$str()), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheNotFound = "ISPN021022: Cache named '%s' was not found.";
    protected String cacheNotFound$str() {
        return cacheNotFound;
    }
    @Override
    public final CacheException cacheNotFound(final String cacheName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cacheNotFound$str(), cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheClosed = "ISPN021023: Cache is closed.";
    protected String cacheClosed$str() {
        return cacheClosed;
    }
    @Override
    public final IllegalStateException cacheClosed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cacheClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheManagerClosed = "ISPN021030: Cache manager is already closed.";
    protected String cacheManagerClosed$str() {
        return cacheManagerClosed;
    }
    @Override
    public final IllegalStateException cacheManagerClosed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cacheManagerClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void errorClosingCloseable(final Closeable closeable, final Exception e) {
        super.log.logf(FQCN, WARN, e, errorClosingCloseable$str(), closeable);
    }
    private static final String errorClosingCloseable = "ISPN021031: Error closing %s";
    protected String errorClosingCloseable$str() {
        return errorClosingCloseable;
    }
    @Override
    public final void getExpiryHasThrown(final Throwable t) {
        super.log.logf(FQCN, WARN, t, getExpiryHasThrown$str());
    }
    private static final String getExpiryHasThrown = "ISPN021032: Exception while getting expiry duration. Fallback to default duration eternal.";
    protected String getExpiryHasThrown$str() {
        return getExpiryHasThrown;
    }
    private static final String unableToInstantiateCacheResolverFactory = "ISPN021033: Unable to instantiate CacheResolverFactory with type '%s'";
    protected String unableToInstantiateCacheResolverFactory$str() {
        return unableToInstantiateCacheResolverFactory;
    }
    @Override
    public final CacheException unableToInstantiateCacheResolverFactory(final Class<?> type, final Throwable cause) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToInstantiateCacheResolverFactory$str(), type), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
