/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.processor;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import org.instancio.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

class MetamodelClass {
    private static final String DEFAULT_SUFFIX = "_";
    private final String name;
    private final String simpleName;
    private final String packageName;
    private final List<String> fieldNames;
    private final String metamodelClassSuffix;

    MetamodelClass(QualifiedNameable classElement, String metamodelClassSuffix) {
        Element packageElement = MetamodelClass.getPackageElement(classElement);
        this.name = classElement.getQualifiedName().toString();
        this.packageName = this.getPackageName((QualifiedNameable)packageElement);
        this.fieldNames = MetamodelClass.getFieldNames(classElement);
        this.simpleName = classElement.getSimpleName().toString();
        this.metamodelClassSuffix = StringUtils.isBlank((String)metamodelClassSuffix) ? DEFAULT_SUFFIX : metamodelClassSuffix.trim();
    }

    private String getPackageName(QualifiedNameable packageElement) {
        String pkg = packageElement.getQualifiedName().toString();
        return "".equals(pkg) ? null : pkg;
    }

    private static Element getPackageElement(Element classElement) {
        Element packageElement = classElement.getEnclosingElement();
        while (packageElement.getKind() != ElementKind.PACKAGE) {
            packageElement = packageElement.getEnclosingElement();
        }
        return packageElement;
    }

    private static List<String> getFieldNames(@Nullable Element typeElement) {
        return typeElement == null ? Collections.emptyList() : typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.FIELD && !e.getModifiers().contains((Object)Modifier.STATIC)).map(elem -> elem.getSimpleName().toString()).collect(Collectors.toList());
    }

    String getName() {
        return this.name;
    }

    String getSimpleName() {
        return this.simpleName;
    }

    String getMetamodelSimpleName() {
        return this.simpleName + this.metamodelClassSuffix;
    }

    String getMetamodelClassName() {
        return this.name + this.metamodelClassSuffix;
    }

    String getPackageName() {
        return this.packageName;
    }

    List<String> getFieldNames() {
        return this.fieldNames;
    }

    public String toString() {
        return this.name;
    }
}

