/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Currency;
import java.util.Locale;
import java.util.Set;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryAmountFactoryQuery;
import javax.money.MonetaryAmountFactoryQueryBuilder;
import javax.money.MonetaryAmounts;
import javax.money.MonetaryCurrencies;
import javax.money.MonetaryException;
import javax.money.MonetaryOperator;
import javax.money.MonetaryRounding;
import javax.money.MonetaryRoundings;
import javax.money.RoundingQuery;
import javax.money.RoundingQueryBuilder;
import org.javamoney.tck.TCKTestSetup;
import org.javamoney.tck.tests.internal.TestAmount;
import org.javamoney.tck.tests.internal.TestCurrencyUnit;
import org.javamoney.tck.tests.internal.TestMonetaryAmountBuilder;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 354", version="1.0.0")
public class AccessingCurrenciesAmountsRoundingsTest {
    @Test(description="4.2.7 Test if MonetaryCurrencies provides all ISO related entries similar to java.util.Currency.")
    @SpecAssertion(section="4.2.7", id="427-A1")
    public void testAllISOCurrenciesAvailable() {
        for (Currency currency : Currency.getAvailableCurrencies()) {
            AssertJUnit.assertTrue((String)("Section 4.2.7: Currency not available [MonetaryCurrencies#isCurrencyAvailable(String)] for JDK currency code: " + currency.getCurrencyCode()), (boolean)MonetaryCurrencies.isCurrencyAvailable((String)currency.getCurrencyCode(), (String[])new String[0]));
            AssertJUnit.assertNotNull((String)("Section 4.2.7: Currency null [MonetaryCurrencies#igetCurrency(String)] for JDK currency code: " + currency.getCurrencyCode()), (Object)MonetaryCurrencies.getCurrency((String)currency.getCurrencyCode(), (String[])new String[0]));
        }
    }

    @Test(description="4.2.7 Test if MonetaryCurrencies provides all locale related entries similar to java.util.Currency.")
    @SpecAssertion(section="4.2.7", id="427-A2")
    public void testAllLocaleCurrenciesAvailable() {
        for (String country : Locale.getISOCountries()) {
            Locale locale = new Locale("", country);
            if (Currency.getInstance(locale) == null) continue;
            AssertJUnit.assertTrue((String)("Section 4.2.7: Currency not available [MonetaryCurrencies#isCurrencyAvailable(Locale)] for locale: " + locale), (boolean)MonetaryCurrencies.isCurrencyAvailable((Locale)locale, (String[])new String[0]));
            AssertJUnit.assertNotNull((String)("Currency null [MonetaryCurrencies#igetCurrency(Locale)] for locale: " + locale), (Object)MonetaryCurrencies.getCurrencies((Locale)locale, (String[])new String[0]));
            Set units = MonetaryCurrencies.getCurrencies((Locale)locale, (String[])new String[0]);
            CurrencyUnit requiredCurrency = null;
            for (CurrencyUnit cu : units) {
                if (!Currency.getInstance(locale).getCurrencyCode().equals(cu.getCurrencyCode())) continue;
                requiredCurrency = cu;
                break;
            }
            AssertJUnit.assertNotNull((String)("Section 4.2.7: No Currency returned from [MonetaryCurrencies#getCurrencies(Locale)] for locale: " + locale), requiredCurrency);
            AssertJUnit.assertEquals((String)("Section 4.2.7: Invalid Currency returned from [MonetaryCurrencies#getCurrencies(Locale)] for locale: " + locale + ", expected: " + Currency.getInstance(locale) + ", found: " + requiredCurrency), (Object)MonetaryCurrencies.getCurrency((String)Currency.getInstance(locale).getCurrencyCode(), (String[])new String[0]), (Object)requiredCurrency);
        }
    }

    @Test(description="4.2.7 Test if MonetaryCurrencies provides correct ISO related entries similar to java.util.Currency.")
    @SpecAssertion(section="4.2.7", id="427-A3")
    public void testCorrectISOCodes() {
        for (Currency currency : Currency.getAvailableCurrencies()) {
            CurrencyUnit unit = MonetaryCurrencies.getCurrency((String)currency.getCurrencyCode(), (String[])new String[0]);
            AssertJUnit.assertEquals((String)("Section 4.2.7: Invalid Currency code returned from [MonetaryCurrencies#igetCurrency(String)] for currency code: " + currency.getCurrencyCode() + ", expected: " + Currency.getInstance(currency.getCurrencyCode()).getCurrencyCode() + ", found: " + unit.getCurrencyCode()), (String)Currency.getInstance(currency.getCurrencyCode()).getCurrencyCode(), (String)unit.getCurrencyCode());
            AssertJUnit.assertEquals((String)("Section 4.2.7: Invalid numeric code returned from [MonetaryCurrencies#igetCurrency(String)] for currency code: " + currency.getCurrencyCode() + ", expected: " + Currency.getInstance(currency.getCurrencyCode()).getNumericCode() + ", found: " + unit.getNumericCode()), (int)Currency.getInstance(currency.getCurrencyCode()).getNumericCode(), (int)unit.getNumericCode());
            AssertJUnit.assertEquals((String)("Section 4.2.7: Invalid default fraction unit returned from [MonetaryCurrencies#igetCurrency(String)] for currency code: " + currency.getCurrencyCode() + ", expected: " + Currency.getInstance(currency.getCurrencyCode()).getDefaultFractionDigits() + ", found: " + unit.getDefaultFractionDigits()), (int)Currency.getInstance(currency.getCurrencyCode()).getDefaultFractionDigits(), (int)unit.getDefaultFractionDigits());
        }
    }

    @Test(description="4.2.7 Test if MonetaryCurrencies provides correct locale related entries similar to java.util.Currency.")
    @SpecAssertion(section="4.2.7", id="427-A4")
    public void testCorrectLocales() {
        MonetaryCurrencies.getCurrencies((Locale)new Locale("", "AD"), (String[])new String[0]);
        for (String country : Locale.getISOCountries()) {
            Locale locale = new Locale("", country);
            if (Currency.getInstance(locale) == null) continue;
            Set units = MonetaryCurrencies.getCurrencies((Locale)locale, (String[])new String[0]);
            AssertJUnit.assertNotNull((String)("Section 4.2.7: Invalid Currencies (null) returned from [MonetaryCurrencies#igetCurrencies(Locale)] for locale: " + locale), (Object)units);
            AssertJUnit.assertFalse((String)("Section 4.2.7: Empty Currencies returned from [MonetaryCurrencies#igetCurrencies(Locale)] for locale: " + locale), (boolean)units.isEmpty());
            CurrencyUnit requiredCurrency = null;
            for (CurrencyUnit cu : units) {
                if (!Currency.getInstance(locale).getCurrencyCode().equals(cu.getCurrencyCode())) continue;
                requiredCurrency = cu;
                break;
            }
            AssertJUnit.assertNotNull((String)("Section 4.2.7: Required Currency missing in result returned from [MonetaryCurrencies#igetCurrency(Locale)] for locale: " + locale + ", expected: " + Currency.getInstance(locale).getCurrencyCode() + ", found: " + units), (Object)requiredCurrency);
            AssertJUnit.assertEquals((String)("Section 4.2.7: Invalid numeric code returned from [MonetaryCurrencies#igetCurrency(Locale)] for locale: " + locale + ", expected: " + Currency.getInstance(locale).getNumericCode() + ", found: " + requiredCurrency.getNumericCode()), (int)Currency.getInstance(locale).getNumericCode(), (int)requiredCurrency.getNumericCode());
            AssertJUnit.assertEquals((String)("Section 4.2.7: Invalid default fraction unit returned from [MonetaryCurrencies#igetCurrency(Locale)] for locale: " + locale + ", expected: " + Currency.getInstance(locale).getDefaultFractionDigits() + ", found: " + requiredCurrency.getDefaultFractionDigits()), (int)Currency.getInstance(locale).getDefaultFractionDigits(), (int)requiredCurrency.getDefaultFractionDigits());
        }
    }

    @Test(description="4.2.7 Test if MonetaryCurrencies provides customized locale identified currencies.")
    @SpecAssertion(section="4.2.7", id="427-A5")
    public void testCustomCurrencies() {
        Locale testLocale = new Locale("lang", "count", "test");
        Set cus = MonetaryCurrencies.getCurrencies((Locale)testLocale, (String[])new String[0]);
        AssertJUnit.assertNotNull((String)("Section 4.2.7: TestCurrency not returned for locale: " + testLocale), (Object)cus);
        AssertJUnit.assertFalse((String)("Section 4.2.7: TestCurrency not returned for locale: " + testLocale), (boolean)cus.isEmpty());
        AssertJUnit.assertEquals((String)"Section 4.2.7: Unexpected CurrencyUnit class returned.", TestCurrencyUnit.class, ((CurrencyUnit)cus.iterator().next()).getClass());
        CurrencyUnit cu = MonetaryCurrencies.getCurrency((String)"FOOLS_test", (String[])new String[0]);
        AssertJUnit.assertNotNull((String)"Section 4.2.7: TestCurrency not returned for currency code: FOOLS_test", (Object)cu);
        AssertJUnit.assertEquals((String)"Section 4.2.7: Unexpected CurrencyUnit class returned.", TestCurrencyUnit.class, cu.getClass());
    }

    @Test(description="4.2.7 Ensure amount classes to test are setup and registered/available in MonetaryAmounts.")
    @SpecAssertion(section="4.2.7", id="427-B2")
    public void testAmountTypesProvided() {
        Collection<Class> amountClasses = TCKTestSetup.getTestConfiguration().getAmountClasses();
        AssertJUnit.assertNotNull(amountClasses);
        AssertJUnit.assertFalse((boolean)amountClasses.isEmpty());
        Collection providedClasses = MonetaryAmounts.getAmountTypes();
        for (Class amountType : amountClasses) {
            AssertJUnit.assertTrue((String)("Section 4.2.7: Amount class not registered: " + amountType.getName()), (boolean)providedClasses.contains(amountType));
        }
        AssertJUnit.assertTrue((String)("Section 4.2.7: TCK Amount class not registered: " + TestAmount.class), (boolean)providedClasses.contains(TestAmount.class));
    }

    @Test(description="4.2.7 Ensure amount factories are accessible for all types available in MonetaryAmounts.")
    @SpecAssertion(section="4.2.7", id="427-B3")
    public void testAmountTypesInstantiatable() {
        Collection<Class> amountClasses = TCKTestSetup.getTestConfiguration().getAmountClasses();
        for (Class amountType : amountClasses) {
            MonetaryAmountFactory f = MonetaryAmounts.getAmountFactory((Class)amountType);
            AssertJUnit.assertNotNull((String)("Section 4.2.7: MonetaryAmountFactory returned by MonetaryAmounts is null for " + amountType.getName()), (Object)f);
            MonetaryAmountFactory f2 = MonetaryAmounts.getAmountFactory((Class)amountType);
            AssertJUnit.assertNotNull((String)("Section 4.2.7: MonetaryAmountFactory returned by MonetaryAmounts is null for " + amountType.getName()), (Object)f2);
            AssertJUnit.assertNotSame((String)("MonetaryAmountFactory instances are not distinct for " + amountType.getName()), (Object)f, (Object)f2);
            TestCurrencyUnit tc = new TestCurrencyUnit();
            MonetaryAmount m1 = f.setNumber(0L).setCurrency((CurrencyUnit)tc).create();
            AssertJUnit.assertNotNull((String)("Section 4.2.7: MonetaryAmountFactory creates null amounts for " + amountType.getName()), (Object)m1);
            AssertJUnit.assertTrue((String)("Section 4.2.7: MonetaryAmountFactory creates non zero amounts for " + amountType.getName()), (boolean)m1.isZero());
            AssertJUnit.assertEquals((String)("Section 4.2.7: MonetaryAmountFactory creates non zero amounts for " + amountType.getName()), (long)0L, (long)m1.getNumber().longValue());
            AssertJUnit.assertTrue((String)("Section 4.2.7: MonetaryAmountFactory creates non assignable amounts instances for " + amountType.getName()), (boolean)amountType.isAssignableFrom(m1.getClass()));
        }
        MonetaryAmountFactory f = MonetaryAmounts.getAmountFactory(TestAmount.class);
        AssertJUnit.assertNotNull((String)("Section 4.2.7: MonetaryAmountFactory returned by MonetaryAmounts is null for " + TestAmount.class.getName()), (Object)f);
        AssertJUnit.assertEquals((String)("MonetaryAmountFactory returned by MonetaryAmounts is obfuscated or proxied for " + TestMonetaryAmountBuilder.class.getName()), TestMonetaryAmountBuilder.class, f.getClass());
    }

    @Test(description="4.2.7 Ensure correct query function, MonetaryAmounts.getAmountFactories should return factoryfor explicit acquired amount types.")
    @SpecAssertion(section="4.2.7", id="427-B4")
    public void testAmountQueryType() {
        MonetaryAmountFactoryQuery ctx = ((MonetaryAmountFactoryQueryBuilder)MonetaryAmountFactoryQueryBuilder.of().setTargetType(TestAmount.class)).build();
        Collection factories = MonetaryAmounts.getAmountFactories((MonetaryAmountFactoryQuery)ctx);
        AssertJUnit.assertNotNull((String)"Section 4.2.7: Amount factory query should return explicitly queried factories", (Object)factories);
        boolean found = false;
        for (MonetaryAmountFactory f : factories) {
            if (!f.getAmountType().equals(TestAmount.class)) continue;
            found = true;
            break;
        }
        AssertJUnit.assertTrue((String)"Section 4.2.7: Amount type query should return same explicitly queried factory", (boolean)found);
        ctx = MonetaryAmountFactoryQueryBuilder.of().build();
        MonetaryAmountFactory factory = MonetaryAmounts.getAmountFactory((MonetaryAmountFactoryQuery)ctx);
        AssertJUnit.assertNotNull((String)"Section 4.2.7: Amount type must be provided", (Object)factory);
    }

    @Test(description="4.2.7 Ensure a default MonetaryAmountFactory is available.")
    @SpecAssertion(section="4.2.7", id="427-B5")
    public void testAmountDefaultType() {
        AssertJUnit.assertNotNull((String)"Section 4.2.7: No default MonetaryAmountFactory found.", (Object)MonetaryAmounts.getDefaultAmountFactory());
    }

    @Test(description="4.2.7 Ensure MonetaryRoundings instances are available, for all registered currencies.")
    @SpecAssertion(section="4.2.7", id="427-C1")
    public void testAccessRoundingsForCustomCurrencies_Default() {
        TestCurrencyUnit cu = new TestCurrencyUnit("ASDF", 3);
        MonetaryRounding r = MonetaryRoundings.getDefaultRounding();
        MonetaryAmount m = new TestMonetaryAmountBuilder().setNumber(new BigDecimal("12.123456789101222232323")).setCurrency((CurrencyUnit)cu).create();
        AssertJUnit.assertEquals((String)"Section 4.2.7: expected ASDF 12.123 with default rounding from ASDF 12.123456789101222232323", (String)"ASDF 12.123", (String)m.with((MonetaryOperator)r).toString());
        for (Currency currency : Currency.getAvailableCurrencies()) {
            m = new TestMonetaryAmountBuilder().setNumber(new BigDecimal("12.123456789101222232323")).setCurrency(currency.getCurrencyCode()).create();
            if (currency.getDefaultFractionDigits() < 0) continue;
            MonetaryAmount rounded = m.with((MonetaryOperator)r);
            AssertJUnit.assertEquals((String)"Section 4.2.7: Returned amount class must be the same as the input class to the rounding operator.", TestAmount.class, rounded.getClass());
            AssertJUnit.assertEquals((String)("Section 4.2.7: Rounding did change currency: " + rounded.getClass().getName()), (String)currency.getCurrencyCode(), (String)rounded.getCurrency().getCurrencyCode());
            AssertJUnit.assertNotSame((String)"Section 4.2.7: Rounding did not have any effect, should use scale==2 as default.", (Object)m.getNumber().getScale(), (Object)rounded.getNumber().getScale());
        }
    }

    @Test(description="4.2.7 Ensure MonetaryRoundings instances are available, also for any custom currency (not registered).")
    @SpecAssertion(section="4.2.7", id="427-C1")
    public void testAccessRoundingsForCustomCurrencies_Explicit() {
        TestCurrencyUnit cu = new TestCurrencyUnit("ASDF", 3);
        MonetaryRounding r = MonetaryRoundings.getRounding((CurrencyUnit)cu, (String[])new String[0]);
        MonetaryAmount m = new TestMonetaryAmountBuilder().setNumber(new BigDecimal("12.123456789101222232323")).setCurrency((CurrencyUnit)cu).create();
        AssertJUnit.assertEquals((String)"Section 4.2.7: Expected ASDF 12.123 for custom rounding 12.123456789101222232323.", (String)"ASDF 12.123", (String)m.with((MonetaryOperator)r).toString());
        for (Currency currency : Currency.getAvailableCurrencies()) {
            if (currency.getDefaultFractionDigits() >= 0) {
                r = MonetaryRoundings.getRounding((CurrencyUnit)cu, (String[])new String[0]);
                m = m.with((MonetaryOperator)r);
                AssertJUnit.assertEquals((String)("Section 4.2.7: Expected ASDF 12.123 for rounding for Currency" + cu.getCurrencyCode()), (String)"ASDF 12.123", (String)m.with((MonetaryOperator)r).toString());
                continue;
            }
            try {
                r = MonetaryRoundings.getRounding((CurrencyUnit)cu, (String[])new String[0]);
                AssertJUnit.assertNotNull((Object)r);
            }
            catch (MonetaryException e) {}
        }
    }

    @Test(expectedExceptions={NullPointerException.class}, description="Section 4.2.7: Expected NullPointerException accessing a rounding with 'MonetaryRoundings.getRounding(null)'.")
    @SpecAssertion(section="4.2.7", id="427-C1")
    public void testAccessRoundingsForCustomCurrencies_Explicit_Null() {
        MonetaryRoundings.getRounding((CurrencyUnit)null, (String[])new String[0]);
    }

    @Test(description="4.2.7 Ensure correct MonetaryRounding returned for a mathematical RoundingQuery.")
    @SpecAssertion(section="4.2.7", id="427-C2")
    public void testAccessRoundingsWithRoundingContext() {
        RoundingQuery ctx = ((RoundingQueryBuilder)RoundingQueryBuilder.of().setScale(1).set((Object)RoundingMode.UP)).build();
        MonetaryRounding r = MonetaryRoundings.getRounding((RoundingQuery)ctx);
        AssertJUnit.assertNotNull((String)("Section 4.2.7: No rounding provided for RoundingQuery: " + ctx), (Object)r);
        MonetaryAmount m = new TestMonetaryAmountBuilder().setNumber(new BigDecimal("12.123456789101222232323")).setCurrency("CHF").create();
        AssertJUnit.assertEquals((String)("Section 4.2.7: Invalid rounding provided for RoundingQuery: " + ctx), (String)"CHF 12.2", (String)m.with((MonetaryOperator)r).toString());
    }

    @Test(expectedExceptions={NullPointerException.class}, description="4.2.7: Ensure NullPointerException is thrown for 'MonetaryRoundings.getRounding((RoundingContext) null)'.")
    @SpecAssertion(section="4.2.7", id="427-C2")
    public void testAccessRoundingsWithMonetaryContext_Null() {
        MonetaryRoundings.getRounding(null);
    }

    @Test(description="4.2.7 Access named roundings and ensure TCK named roundings are registered.")
    @SpecAssertion(section="4.2.7", id="427-C3")
    public void testAccessCustomRoundings() {
        Set ids = MonetaryRoundings.getRoundingNames((String[])new String[0]);
        AssertJUnit.assertNotNull((String)"Section 4.2.7: Custom Rounding key are null", (Object)ids);
        AssertJUnit.assertTrue((String)"Section 4.2.7: At least NOSCALE custom rounding must be present", (boolean)ids.contains("NOSCALE"));
    }

    @Test(description="4.2.7 Access custom roundings and ensure correct functionality.")
    @SpecAssertion(section="4.2.7", id="427-C4")
    public void testCustomRoundings() {
        MonetaryRounding r = MonetaryRoundings.getRounding((String)"NOSCALE", (String[])new String[0]);
        AssertJUnit.assertNotNull((Object)r);
        MonetaryAmount m = new TestMonetaryAmountBuilder().setNumber(new BigDecimal("12.123456789101222232323")).setCurrency("CHF").create();
        AssertJUnit.assertEquals((String)("Section 4.2.7: Expected CHF 12 for NOSCALE operator on " + m), (String)"CHF 12", (String)m.with((MonetaryOperator)r).toString());
    }

    @Test(expectedExceptions={NullPointerException.class}, description="4.2.7 Ensure NullPointerException is thrown for MonetaryRoundings.getRounding((String) null).")
    @SpecAssertion(section="4.2.7", id="427-C4")
    public void testCustomRoundings_Null() {
        MonetaryRoundings.getRounding((String)null, (String[])new String[0]);
    }

    @Test(expectedExceptions={MonetaryException.class}, description="4.2.7 Ensure MonetaryException is thrown for accessing invalid named rounding.")
    @SpecAssertion(section="4.2.7", id="427-C4")
    public void testCustomRoundings_Foo() {
        Assert.assertNotNull((String)"Section 4.2.7: Expected custom rounding with name 'foo'.", (Object)MonetaryRoundings.getRounding((String)"foo", (String[])new String[0]));
    }
}

