/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmounts;
import javax.money.MonetaryException;
import javax.money.NumberValue;
import org.javamoney.tck.tests.internal.TestAmount;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 354", version="1.0.0")
public class ExternalizingNumericValueTest {
    private static final String DEFAULT_CURRENCY = "CHF";
    private Class[] requiredJdkTykes = new Class[]{Integer.class, Long.class, Double.class, BigDecimal.class, BigInteger.class};

    @Test(description="4.2.3 Amount types do not return a NumberValue of null.")
    @SpecAssertion(section="4.2.3", id="423-A1")
    public void testReturningNumberValueIsNotNull() {
        for (Class type : MonetaryAmounts.getAmountTypes()) {
            if (type.equals(TestAmount.class)) continue;
            MonetaryAmount mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(10L).create();
            NumberValue result = mAmount1.getNumber();
            AssertJUnit.assertNotNull((String)("Section 4.2.3: Amount type does not return a NumberValue (null); " + type.getName()), (Object)result);
        }
    }

    @Test(description="4.2.3 Ensure NumberValue intValue(), intValueExact() provide correct values.")
    @SpecAssertion(section="4.2.3", id="423-A2")
    public void testValidInteger() {
        int[] nums;
        for (int num : nums = new int[]{-3, -1, 0, 1, 3}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                if (type.equals(TestAmount.class)) continue;
                MonetaryAmount mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber((long)num).create();
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertNotNull((String)("Section 4.2.3: Amount creation failed for " + type), (Object)result);
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (int) returned is not correct for " + type.getName()), (int)num, (int)result.intValue());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Exact number value (int) returned is not correct for " + type.getName()), (int)num, (int)result.intValueExact());
            }
        }
    }

    @Test(description="4.2.3 Ensure NumberValue longValue(), longValueExact() provide correct values.")
    @SpecAssertion(section="4.2.3", id="423-A3")
    public void testValidLong() {
        long[] nums;
        for (long num : nums = new long[]{1L, 3L, 11L, 123L, 12345L, 1223345566L, 1234523462532753243L}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertNotNull((String)("Section 4.2.3: Amount creation failed for " + type), (Object)result);
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (long) returned is not correct for " + type.getName()), (long)num, (long)result.longValue());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Exact number (long) (double) returned is not correct for " + type.getName()), (long)num, (long)result.longValueExact());
            }
        }
    }

    @Test(description="4.2.3 Ensure NumberValue doubleValue(), doubleValueExact() provide correct values.")
    @SpecAssertion(section="4.2.3", id="423-A4")
    public void testValidDouble() {
        double[] nums;
        for (double num : nums = new double[]{0.0, 0.3, 1.0, 1.3453}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                if (type.equals(TestAmount.class)) continue;
                MonetaryAmount mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertNotNull((String)("Section 4.2.3: Amount creation failed for " + type), (Object)result);
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (double) returned is not correct for " + type.getName()), (double)num, (double)result.doubleValue(), (double)0.0);
                AssertJUnit.assertEquals((String)("Section 4.2.3: Exact number value (double) returned is not correct for " + type.getName()), (double)num, (double)result.doubleValueExact(), (double)0.0);
            }
        }
    }

    @Test(description="4.2.3 Ensure NumberValue asType(BigDecimal.class) provides correct values.")
    @SpecAssertion(section="4.2.3", id="423-A5")
    public void testValidNumberBD() {
        Number[] nums;
        for (Number num : nums = new Number[]{-3, Float.valueOf(-4.5f), -1.2, (short)0, 0.3, (byte)1, 1.3453}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                if (type.equals(TestAmount.class)) continue;
                MonetaryAmount mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (BigDecimal) returned is not correct for " + type.getName()), (Object)new BigDecimal(String.valueOf(num)).stripTrailingZeros(), (Object)((BigDecimal)result.numberValue(BigDecimal.class)).stripTrailingZeros());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Exact number value (BigDecimal) returned is not correct for " + type.getName()), (Object)new BigDecimal(String.valueOf(num)).stripTrailingZeros(), (Object)((BigDecimal)result.numberValue(BigDecimal.class)).stripTrailingZeros());
            }
        }
    }

    @Test(description="4.2.3 Ensure NumberValue asType(BigInteger.class) provides correct values.")
    @SpecAssertion(section="4.2.3", id="423-A5")
    public void testValidNumberBI() {
        Number[] nums;
        for (Number num : nums = new Number[]{-3, -1L, (short)0, (byte)1}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                if (type.equals(TestAmount.class)) continue;
                MonetaryAmount mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (BigInteger) returned is not correct for " + type.getName()), (Object)new BigInteger(String.valueOf(num)), (Object)result.numberValue(BigInteger.class));
                AssertJUnit.assertEquals((String)("Section 4.2.3: Exact number value (BigInteger) returned is not correct for " + type.getName()), (Object)new BigInteger(String.valueOf(num)), (Object)result.numberValue(BigInteger.class));
            }
        }
    }

    @Test(description="4.2.3 Ensure NumberValue intValue() is truncated.")
    @SpecAssertion(section="4.2.3", id="423-A6")
    public void testValidIntegerWithTruncation() {
        double[] nums;
        for (double num : nums = new double[]{-3.12334, -1.23345, 0.4343, 1.3343435, 5.345454}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (int, truncated) returned is not correct for " + type.getName()), (int)((int)num), (int)result.intValue());
                try {
                    result.intValueExact();
                    AssertJUnit.fail((String)("Section 4.2.3: Number value (int, exact -> truncated) must throw ArithemticException on truncation for " + type.getName()));
                }
                catch (ArithmeticException e) {}
            }
        }
    }

    @Test(description="4.2.3 Ensure NumberValue longValue() is truncated.")
    @SpecAssertion(section="4.2.3", id="423-A7")
    public void testValidLongWithTruncation() {
        double[] nums;
        for (double num : nums = new double[]{0.4343, 1.3343435, 5.345454}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (long, truncated) returned is not correct for " + type.getName()), (long)((long)num), (long)result.intValue());
                try {
                    result.longValueExact();
                    AssertJUnit.fail((String)("Section 4.2.3: Number value (long, exact -> truncated) must throw ArithemticException on truncation for " + type.getName()));
                }
                catch (ArithmeticException e) {}
            }
        }
    }

    @Test(description="4.2.3 Ensure NumberValue doubleValue() is truncated.")
    @SpecAssertion(section="4.2.3", id="423-A8")
    public void testValidDoubleWithTruncation() {
        Number[] nums;
        for (Number num : nums = new Number[]{new BigDecimal("26353527352735725372357.287362873287362836283"), 3232232334423L, 3.3434243242342343E19, 1L, 1.2435535454353455, (short)0, 0.3, (byte)1, 1.3453, 32432532}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (Double, truncating) returned is not correct for " + type.getName()), (double)new BigDecimal(String.valueOf(num)).doubleValue(), (double)result.doubleValue(), (double)0.0);
            }
        }
    }

    @Test(description="4.2.3 Ensure NumberValue byteValue() is truncated.")
    @SpecAssertion(section="4.2.3", id="423-A9")
    public void testValidNumberWithTruncation_Byte() {
        Number[] nums;
        for (Number num : nums = new Number[]{-3232423, Float.valueOf(-4.5f), -1.2, (short)0, 0.3, (byte)1, 1.3453, 32432532}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (Byte, truncating) returned is not correct for " + type.getName()), (byte)new BigDecimal(String.valueOf(num)).byteValue(), (byte)((Byte)result.numberValue(Byte.class)));
            }
        }
    }

    @Test(description="4.2.3 Ensure NumberValue shortValue() is truncated.")
    @SpecAssertion(section="4.2.3", id="423-A9")
    public void testValidNumberWithTruncation_Short() {
        Number[] nums;
        for (Number num : nums = new Number[]{-3232423, Float.valueOf(-4.5f), -1.2, (short)0, 0.3, (byte)1, 1.3453, 32432532}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (Short, truncating) returned is not correct for " + type.getName()), (short)new BigDecimal(String.valueOf(num)).shortValue(), (short)((Short)result.numberValue(Short.class)));
            }
        }
    }

    @Test(description="4.2.3 Ensure NumberValue floatValue() is truncated.")
    @SpecAssertion(section="4.2.3", id="423-A9")
    public void testValidNumberWithTruncation_Float() {
        Number[] nums;
        for (Number num : nums = new Number[]{-3232232334423L, -3.3434243242342343E19, -1.2435535454353455, (short)0, 0.3, (byte)1, 1.3453, 32432532}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (Float, truncating) returned is not correct for " + type.getName()), (float)new BigDecimal(String.valueOf(num)).floatValue(), (float)((Float)result.numberValue(Float.class)).floatValue(), (float)0.0f);
            }
        }
    }

    @Test(description="4.2.3 Ensure NumberValue doubleValue() is truncated.")
    @SpecAssertion(section="4.2.3", id="423-A9")
    public void testValidNumberWithTruncation_Double() {
        Number[] nums;
        for (Number num : nums = new Number[]{new BigDecimal("26353527352735725372357.287362873287362836283"), new BigDecimal("-26353527352735725372357.287362873287362836283"), -3232232334423L, -3.3434243242342343E19, -1.2435535454353455, (short)0, 0.3, (byte)1, 1.3453, 32432532}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (Double, truncating) returned is not correct for " + type.getName()), (double)new BigDecimal(String.valueOf(num)).doubleValue(), (double)((Double)result.numberValue(Double.class)), (double)0.0);
            }
        }
    }

    @Test(description="4.2.3 Ensure NumberValue intValue() is truncated correctly.")
    @SpecAssertion(section="4.2.3", id="423-A9")
    public void testValidNumberWithTruncation_Integer() {
        Number[] nums;
        for (Number num : nums = new Number[]{-3232423, Float.valueOf(-4.5f), -1.2, (short)0, 0.3, (byte)1, 1.3453, 32432532}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (short, truncating) returned is not correct for " + type.getName()), (int)new BigDecimal(String.valueOf(num)).intValue(), (int)((Integer)result.numberValue(Integer.class)));
            }
        }
    }

    @Test(description="4.2.3 Ensure NumberValue getPrecision() works correctly.")
    @SpecAssertion(section="4.2.3", id="423-A10")
    public void testPrecisionValues() {
        String[] nums;
        for (String num : nums = new String[]{"1.12", "1.12", "1.123", "1.1234", "1.12345", "1.123456", "1.1234567", "1.12345678", "1.123456789", "12.12", "123.12", "1234.123", "12345.1234", "123456.12345", "123456.123456", "12345678.1234567", "12345678.12345678", "-123456789.123456789", "1", "12", "123", "1234", "12345", "123456", "1234567", "12345678", "123456789"}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                BigDecimal bd = new BigDecimal(num);
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber((Number)bd).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Amount's precision does not match for " + bd + " correct for " + type.getName()), (int)bd.precision(), (int)result.getPrecision());
            }
        }
    }

    @Test(description="4.2.3 Ensure NumberValue getScale() works correctly.")
    @SpecAssertion(section="4.2.3", id="423-A11")
    public void testScaleValues() {
        String[] nums;
        for (String num : nums = new String[]{"1.12", "1.12", "1.123", "1.1234", "1.12345", "1.123456", "1.1234567", "1.12345678", "1.123456789", "12.12", "123.12", "1234.123", "12345.1234", "123456.12345", "123456.123456", "12345678.1234567", "12345678.12345678", "-123456789.123456789", "1", "12", "123", "1234", "12345", "123456", "1234567", "12345678", "123456789"}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                BigDecimal bd = new BigDecimal(num);
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber((Number)bd).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Amount's precision does not match for " + bd + " correct for " + type.getName()), (int)bd.scale(), (int)result.getScale());
            }
        }
    }

    @Test(description="4.2.3 Ensure NumberValue numberValue() works correnctly.")
    @SpecAssertion(section="4.2.3", id="423-B1")
    public void testNumberTypeNegative() {
        Number[] nums;
        for (Number num : nums = new Number[]{-1213243544435L, -3, Float.valueOf(-4.5f), -1.2, -2.132323432432423E13}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                if (type.equals(TestAmount.class)) continue;
                MonetaryAmount mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (BigDecimal) returned is not correct for " + type.getName()), (Object)new BigDecimal(String.valueOf(num)).stripTrailingZeros(), (Object)((BigDecimal)result.numberValue(BigDecimal.class)).stripTrailingZeros());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Exact number value (BigDecimal) returned is not correct for " + type.getName()), (Object)new BigDecimal(String.valueOf(num)).stripTrailingZeros(), (Object)((BigDecimal)result.numberValue(BigDecimal.class)).stripTrailingZeros());
            }
        }
    }

    @Test(description="4.2.3 Checks if a correct Integer value is returned, no truncation is allowed to be performed.")
    @SpecAssertion(section="4.2.3", id="423-B2")
    public void testIntegerNegative() {
        int[] nums;
        int[] nArray = nums = new int[]{-1, -3, -11, -123, -12345, -1223345566};
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long num = nArray[i];
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                if (type.equals(TestAmount.class)) continue;
                MonetaryAmount mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertNotNull((String)("Section 4.2.3: Amount creation failed for " + type), (Object)result);
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (int) returned is not correct for " + type.getName()), (long)num, (long)result.intValue());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Exact number (int) returned is not correct for " + type.getName()), (long)num, (long)result.intValueExact());
            }
        }
    }

    @Test(description="4.2.3 Checks if a correct negative long value is returned, no truncation is allowed to be performed.")
    @SpecAssertion(section="4.2.3", id="423-B3")
    public void testLongNegative() {
        long[] nums;
        for (long num : nums = new long[]{-1L, -3L, -11L, -123L, -12345L, -1223345566L, -1234523462532753243L}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertNotNull((String)("Section 4.2.3: Amount creation failed for " + type), (Object)result);
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (long) returned is not correct for " + type.getName()), (long)num, (long)result.longValue());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Exact number (long) returned is not correct for " + type.getName()), (long)num, (long)result.longValueExact());
            }
        }
    }

    @Test(description="4.2.3 Checks if a correct Double value is returned, no truncation is allowed to be performed.")
    @SpecAssertion(section="4.2.3", id="423-B4")
    public void testDoubleNegative() {
        double[] nums;
        for (double num : nums = new double[]{-3.12334, -1.235, -0.43, -1.35, -52.4, -12345.0, 123.0, -1223243.342325435}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (double, truncated) returned is not correct for " + type.getName()), (double)num, (double)result.doubleValue(), (double)0.0);
            }
        }
    }

    @Test(description="4.2.3 Check if a correct number value is returned, truncation is  allowed to be performed. Check should be done for every JDK type supported.")
    @SpecAssertion(section="4.2.3", id="423-B5")
    public void testNumberWithTruncationNegative() {
        double[] nums;
        for (double num : nums = new double[]{-1.0, -1.1, -1.1111111111111112E39}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                BigDecimal dec = new BigDecimal(String.valueOf(num));
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                for (Class numType : this.requiredJdkTykes) {
                    if (Byte.class.equals((Object)numType)) {
                        AssertJUnit.assertEquals((String)("Section 4.2.3: Truncating conversion to byte failed for type " + type.getName()), (byte)dec.byteValue(), (byte)result.byteValue());
                        continue;
                    }
                    if (Short.class.equals((Object)numType)) {
                        AssertJUnit.assertEquals((String)("Section 4.2.3: Truncating conversion to short failed for type " + type.getName()), (short)dec.shortValue(), (short)result.shortValue());
                        continue;
                    }
                    if (Integer.class.equals((Object)numType)) {
                        AssertJUnit.assertEquals((String)("Section 4.2.3: Truncating conversion to int failed for type " + type.getName()), (int)dec.intValue(), (int)result.intValue());
                        continue;
                    }
                    if (Long.class.equals((Object)numType)) {
                        AssertJUnit.assertEquals((String)("Section 4.2.3: Truncating conversion to long failed for type " + type.getName()), (long)dec.longValue(), (long)result.longValue());
                        continue;
                    }
                    if (Float.class.equals((Object)numType)) {
                        AssertJUnit.assertEquals((String)("Section 4.2.3: Truncating conversion to float failed for type " + type.getName()), (float)dec.floatValue(), (float)result.floatValue(), (float)0.0f);
                        continue;
                    }
                    if (Double.class.equals((Object)numType)) {
                        AssertJUnit.assertEquals((String)("Section 4.2.3: Truncating conversion to double failed for type " + type.getName()), (double)dec.doubleValue(), (double)result.doubleValue(), (double)0.0);
                        continue;
                    }
                    if (BigDecimal.class.equals((Object)numType)) {
                        AssertJUnit.assertEquals((String)("Section 4.2.3: Truncating conversion to BigDecimal failed for type " + type.getName()), (Object)dec.stripTrailingZeros(), (Object)((BigDecimal)result.numberValue(BigDecimal.class)).stripTrailingZeros());
                        continue;
                    }
                    if (!BigInteger.class.equals((Object)numType)) continue;
                    AssertJUnit.assertEquals((String)("Section 4.2.3: Truncating conversion to BigInteger failed for type " + type.getName()), (Object)dec.toBigInteger(), (Object)result.numberValue(BigInteger.class));
                }
            }
        }
    }

    @Test(description="4.2.3 Check if a correct integer value is returned, truncation is allowed to be performed..")
    @SpecAssertion(section="4.2.3", id="423-B6")
    public void testIntegerWithTruncationNegative() {
        double[] nums;
        for (double num : nums = new double[]{-1.1, -3.12, -11.123, -123.1234, -12345.12233, -1.2233455662332432E9}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (int) returned is not correct for " + type.getName()), (int)((int)num), (int)result.intValue());
            }
        }
    }

    @Test(description="4.2.3 Checks if a correct long value is returned, truncation is allowed to be performed.")
    @SpecAssertion(section="4.2.3", id="423-B7")
    public void testLongWithTruncationNegative() {
        double[] nums;
        for (double num : nums = new double[]{-3.12334, -1.23345, -1223234.23}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (long, truncated) returned is not correct for " + type.getName()), (long)((long)num), (long)result.intValue());
                try {
                    result.longValueExact();
                    AssertJUnit.fail((String)("Section 4.2.3: Number value (long, exact -> truncated) must throw ArithemticException on truncation for " + type.getName()));
                }
                catch (ArithmeticException e) {}
            }
        }
    }

    @Test(description="4.2.3 Checks if a correct double value is returned, truncation is allowed to be performed.")
    @SpecAssertion(section="4.2.3", id="423-B8")
    public void testDoubleWithTruncationNegative() {
        Number[] nums;
        for (Number num : nums = new Number[]{new BigDecimal("-26353527352735725372357.287362873287362836283"), -3232232334423L, -3.3434243242342343E19, -1L, -1.2435535454353455, (short)0, -0.3, (byte)-1, -1.3453, 32432532}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (Double, truncating) returned is not correct for " + type.getName()), (double)new BigDecimal(String.valueOf(num)).doubleValue(), (double)result.doubleValue(), (double)0.0);
            }
        }
    }

    @Test(description="4.2.3 Checks if a correct long value is returned, truncation is allowed to be performed. Check should be done for every JDK type.")
    @SpecAssertion(section="4.2.3", id="423-B9")
    public void testNumberValueWithTruncationNegative() {
        Number[] nums;
        for (Number num : nums = new Number[]{-1213243544435L, -3234, -4.6, -1.2, -2.132323432432423E13}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                if (type.equals(TestAmount.class)) continue;
                MonetaryAmount mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (BigDecimal -> byte) returned is not correct for " + type.getName()), (long)new BigDecimal(String.valueOf(num)).byteValue(), (long)((Byte)result.numberValue(Byte.class)).byteValue());
            }
        }
    }

    @Test(description="4.2.3 Checks if a correct double value is returned, truncation is allowed to be performed. Check should be done for every JDK type.")
    @SpecAssertion(section="4.2.3", id="423-B9")
    public void testNumberValueWithTruncationNegative_Short() {
        Number[] nums;
        for (Number num : nums = new Number[]{-1213243544435L, -3234, -4.6, -1.2, -2.132323432432423E13}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                if (type.equals(TestAmount.class)) continue;
                MonetaryAmount mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (BigDecimal -> byte) returned is not correct for " + type.getName()), (long)new BigDecimal(String.valueOf(num)).shortValue(), (long)((Short)result.numberValue(Short.class)).shortValue());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (BigDecimal -> byte) returned is not correct for " + type.getName()), (long)new BigDecimal(String.valueOf(num)).shortValue(), (long)result.shortValue());
            }
        }
    }

    @Test(description="4.2.3 Checks if a correct int value is returned, truncation is allowed to be performed. Check should be done for every JDK type.")
    @SpecAssertion(section="4.2.3", id="423-B9")
    public void testNumberValueWithTruncationNegative_Integer() {
        Number[] nums;
        for (Number num : nums = new Number[]{-1213243544435L, -3234, -4.6, -1.2, -2.132323432432423E13}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                if (type.equals(TestAmount.class)) continue;
                MonetaryAmount mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (BigDecimal -> byte) returned is not correct for " + type.getName()), (long)new BigDecimal(String.valueOf(num)).intValue(), (long)((Integer)result.numberValue(Integer.class)).intValue());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (BigDecimal -> byte) returned is not correct for " + type.getName()), (long)new BigDecimal(String.valueOf(num)).intValue(), (long)result.intValue());
            }
        }
    }

    @Test(description="4.2.3 Checks if a correct Number value is returned, truncation is allowed to be performed. Check should be done for every JDK type.")
    @SpecAssertion(section="4.2.3", id="423-B9")
    public void testNumberValueWithTruncationNegative_Long() {
        Number[] nums;
        for (Number num : nums = new Number[]{-1213243544435L, -3234, -4.6, -1.2, -2.132323432432423E13}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                if (type.equals(TestAmount.class)) continue;
                MonetaryAmount mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (BigDecimal -> byte) returned is not correct for " + type.getName()), (long)new BigDecimal(String.valueOf(num)).longValue(), (long)((Long)result.numberValue(Long.class)));
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (BigDecimal -> byte) returned is not correct for " + type.getName()), (long)new BigDecimal(String.valueOf(num)).longValue(), (long)result.longValue());
            }
        }
    }

    @Test(description="4.2.3 Checks if a correct double value is returned, truncation is allowed to be performed. Check should be done for every JDK type.")
    @SpecAssertion(section="4.2.3", id="423-B9")
    public void testNumberValueWithTruncationNegative_Float() {
        Number[] nums;
        for (Number num : nums = new Number[]{-1213243544435L, -3234, -4.6, -1.2, -2.132323432432423E13}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                if (type.equals(TestAmount.class)) continue;
                MonetaryAmount mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (BigDecimal -> float) returned is not correct for " + type.getName()), (double)new BigDecimal(String.valueOf(num)).floatValue(), (double)((Float)result.numberValue(Float.class)).floatValue(), (double)0.0);
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (BigDecimal -> float) returned is not correct for " + type.getName()), (double)new BigDecimal(String.valueOf(num)).floatValue(), (double)result.floatValue(), (double)0.0);
            }
        }
    }

    @Test(description="4.2.3 Checks if a correct double value is returned, truncation is allowed to be performed. Check should be done for every JDK type.")
    @SpecAssertion(section="4.2.3", id="423-B9")
    public void testNumberValueWithTruncationNegative_Double() {
        Number[] nums;
        for (Number num : nums = new Number[]{-1213243544435L, -3234, -4.6, -1.2, -2.132323432432423E13}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                if (type.equals(TestAmount.class)) continue;
                MonetaryAmount mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (BigDecimal -> double) returned is not correct for " + type.getName()), (double)new BigDecimal(String.valueOf(num)).doubleValue(), (double)((Double)result.numberValue(Double.class)), (double)0.0);
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (BigDecimal -> double) returned is not correct for " + type.getName()), (double)new BigDecimal(String.valueOf(num)).doubleValue(), (double)result.doubleValue(), (double)0.0);
            }
        }
    }

    @Test(description="4.2.3 Test correct precision values, including border cases.")
    @SpecAssertion(section="4.2.3", id="423-B10")
    public void testPrecisionNegative() {
        String[] nums;
        for (String num : nums = new String[]{"-1.12", "-1.12", "-1.123", "-1.1234", "-1.12345", "-1.123456", "-1.1234567", "-1.12345678", "-1.123456789", "-12.12", "-123.12", "-1234.123", "-12345.1234", "-123456.12345", "-123456.123456", "-12345678.1234567", "-12345678.12345678", "-123456789.123456789", "-1", "-12", "-123", "-1234", "-12345", "-123456", "-1234567", "-12345678", "-123456789"}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                BigDecimal bd = new BigDecimal(num);
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber((Number)bd).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Amount's precision does not match for " + bd + " correct for " + type.getName()), (int)bd.precision(), (int)result.getPrecision());
            }
        }
    }

    @Test(description="4.2.3 Test correct scale values, including border cases.")
    @SpecAssertion(section="4.2.3", id="423-B11")
    public void testScaleNegative() {
        String[] nums;
        for (String num : nums = new String[]{"-1.12", "-1.12", "-1.123", "-1.1234", "-1.12345", "-1.123456", "-1.1234567", "-1.12345678", "-1.123456789", "-12.12", "-123.12", "-1234.123", "-12345.1234", "-123456.12345", "-123456.123456", "-12345678.1234567", "-12345678.12345678", "-123456789.123456789", "-1", "-12", "-123", "-1234", "-12345", "-123456", "-1234567", "-12345678", "-123456789"}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                BigDecimal bd = new BigDecimal(num);
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber((Number)bd).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Amount's scale does not match for " + bd + " correct for " + type.getName()), (int)bd.scale(), (int)result.getScale());
            }
        }
    }

    @Test(description="4.2.3 Checks if number type is not null and returning a concrete (no abstract class or interface).")
    @SpecAssertion(section="4.2.3", id="423-C1")
    public void testNumberTypeZero() {
        Number[] nums;
        for (Number num : nums = new Number[]{new BigDecimal("-0.0"), new BigDecimal("0"), new BigInteger("0"), 0, 0L, (byte)0, Float.valueOf(0.0f), 0.0}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (byte) returned is not correct for " + type.getName()), (float)new BigDecimal(String.valueOf(num)).byteValue(), (float)0.0f, (float)((Byte)result.numberValue(Byte.class)).byteValue());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (short) returned is not correct for " + type.getName()), (float)new BigDecimal(String.valueOf(num)).shortValue(), (float)0.0f, (float)((Short)result.numberValue(Short.class)).shortValue());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (int) returned is not correct for " + type.getName()), (float)new BigDecimal(String.valueOf(num)).intValue(), (float)0.0f, (float)((Integer)result.numberValue(Integer.class)).intValue());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (long) returned is not correct for " + type.getName()), (float)new BigDecimal(String.valueOf(num)).longValue(), (float)0.0f, (float)((Long)result.numberValue(Long.class)).longValue());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (float) returned is not correct for " + type.getName()), (float)new BigDecimal(String.valueOf(num)).floatValue(), (float)0.0f, (float)((Float)result.numberValue(Float.class)).floatValue());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (double) returned is not correct for " + type.getName()), (double)new BigDecimal(String.valueOf(num)).doubleValue(), (double)0.0, (double)((Double)result.numberValue(Double.class)));
            }
        }
    }

    @Test(description="4.2.3 Check if a correct integer value is returned, no truncation is  allowed to be performed.")
    @SpecAssertion(section="4.2.3", id="423-C2")
    public void testIntegerZero() {
        Number[] nums;
        for (Number num : nums = new Number[]{0, 0.0, -0.0, new BigDecimal("0.000000000000000000000000000001"), new BigDecimal("-0.000000000000000000000000000001"), new BigInteger("0")}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (int, truncating) returned is not correct for " + num + ", type; " + type.getName()), (int)0, (int)result.intValue());
            }
        }
    }

    @Test(description="4.2.3 Check if a correct long zero value is returned, no truncation is  allowed to be performed.")
    @SpecAssertion(section="4.2.3", id="423-C3")
    public void testLongZero() {
        Number[] nums;
        for (Number num : nums = new Number[]{0, 0.0, -0.0, new BigDecimal("0.00000000000000000000000000000"), new BigDecimal("-0.00000000000000000000000000000"), new BigInteger("0")}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (long, truncating) returned is not correct for " + num + ", type; " + type.getName()), (long)0L, (long)result.longValue());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (long, exact) returned is not correct for " + num + ", type; " + type.getName()), (long)0L, (long)result.longValue());
            }
        }
    }

    @Test(description="4.2.3 Check if a correct long zero value is returned, no truncation is  allowed to be performed.")
    @SpecAssertion(section="4.2.3", id="423-C5")
    public void testNumberValueZero() {
        Number[] nums;
        for (Number num : nums = new Number[]{0.0, -0.0, new BigDecimal("0.00000"), new BigDecimal("-0.000000000000000000000"), new BigInteger("0")}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (Number, long) returned is not correct for " + num + ", type; " + type.getName()), (long)0L, (long)((BigDecimal)result.numberValue(BigDecimal.class)).longValueExact());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (Number, short) returned is not correct for " + num + ", type; " + type.getName()), (float)0.0f, (float)((Short)result.numberValue(Short.class)).floatValue(), (float)0.0f);
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (Number, int) returned is not correct for " + num + ", type; " + type.getName()), (int)0, (int)((Short)result.numberValue(Short.class)).intValue());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (Number, double) returned is not correct for " + num + ", type; " + type.getName()), (double)0.0, (double)((Double)result.numberValue(Double.class)), (double)0.0);
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (Number, BigInteger) returned is not correct for " + num + ", type; " + type.getName()), (long)0L, (long)((BigInteger)result.numberValue(BigInteger.class)).longValueExact());
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (Number, BigDecimal) returned is not correct for " + num + ", type; " + type.getName()), (long)0L, (long)((BigDecimal)result.numberValue(BigDecimal.class)).longValueExact());
                result.numberValueExact(BigDecimal.class);
            }
        }
    }

    @Test(description="4.2.3 Check if a correct integer value is returned, truncation is allowed to be performed. Check should be done for every JDK type supported.")
    @SpecAssertion(section="4.2.3", id="423-C6")
    public void testIntegerValueWithTruncationZero() {
        Number[] nums;
        for (Number num : nums = new Number[]{0.01, -0.02, new BigDecimal("0.000001"), new BigDecimal("-0.0000000000000000000001")}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (int, truncating) returned is not correct for " + num + ", type; " + type.getName()), (long)0L, (long)result.intValue());
                try {
                    result.intValueExact();
                    AssertJUnit.fail((String)("Section 4.2.3: Number value (int, exact) should throw ArithmeticException for " + num + ", type; " + type.getName()));
                }
                catch (ArithmeticException e) {}
            }
        }
    }

    @Test(description="4.2.3 Check if a correct long value is returned, truncation is allowed to be performed. Check should be done for every JDK type supported.")
    @SpecAssertion(section="4.2.3", id="423-C7")
    public void testLongValueWithTruncationZero() {
        Number[] nums;
        for (Number num : nums = new Number[]{0.01, -0.02, new BigDecimal("0.000001"), new BigDecimal("-0.0000000000000000000001")}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (long, truncating) returned is not correct for " + num + ", type; " + type.getName()), (long)0L, (long)result.longValue());
                try {
                    result.longValueExact();
                    AssertJUnit.fail((String)("Section 4.2.3: Number value (long, exact) should throw ArithmeticException for " + num + ", type; " + type.getName()));
                }
                catch (ArithmeticException e) {}
            }
        }
    }

    @Test(description="4.2.3 Check if a correct double value is returned, truncation is allowed to be performed (but is not necessary).")
    @SpecAssertion(section="4.2.3", id="423-C8")
    public void testDoubleValueWithTruncationZero() {
        Number[] nums;
        for (Number num : nums = new Number[]{new BigDecimal("-0.000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001234")}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (Double, truncating) returned is not correct for " + type.getName()), (double)new BigDecimal(String.valueOf(num)).doubleValue(), (double)result.doubleValue(), (double)0.0);
            }
        }
    }

    @Test(description="4.2.3 Check if a correct Number value is returned, truncation is allowed to be performed. Check should be done for every JDK type supported.")
    @SpecAssertion(section="4.2.3", id="423-C9")
    public void testNumberValueWithTruncationZero() {
        Number[] nums;
        for (Number num : nums = new Number[]{new BigDecimal("-0000000000000000.00000000000000000000000000000000000001234")}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber(num).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Number value (Double, truncating) returned is not correct for " + type.getName()), (double)new BigDecimal(String.valueOf(num)).doubleValue(), (double)result.doubleValue(), (double)0.0);
            }
        }
    }

    @Test(description="4.2.3 Check if a correct precision value is returned. Check should be done for every JDK type supported.")
    @SpecAssertion(section="4.2.3", id="423-C10")
    public void testPrecisionZero() {
        String[] nums;
        for (String num : nums = new String[]{"-0", "0", "-0.0", "0.0", "-0.00", "0.00", "-0.000", "0.0000", "0.00000", "-0.0000000", "-0.000000000", "-0.00000000000"}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                BigDecimal bd = new BigDecimal(num);
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber((Number)bd).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertEquals((String)("Section 4.2.3: Amount's scale does not match for " + bd + " correct for " + type.getName()), (int)bd.precision(), (int)result.getPrecision());
            }
        }
    }

    @Test(description="4.2.3 Check if a correct scale value is returned. Check should be done for every JDK type supported.")
    @SpecAssertion(section="4.2.3", id="423-C11")
    public void testScaleZero() {
        String[] nums;
        for (String num : nums = new String[]{"-0", "-0.0", "-0.00", "-0.000", "-0.0000", "-0.00000", "-0.000000", "-0.00000000"}) {
            for (Class type : MonetaryAmounts.getAmountTypes()) {
                MonetaryAmount mAmount1;
                if (type.equals(TestAmount.class)) continue;
                BigDecimal bd = new BigDecimal(num);
                try {
                    mAmount1 = MonetaryAmounts.getAmountFactory((Class)type).setCurrency(DEFAULT_CURRENCY).setNumber((Number)bd).create();
                }
                catch (ArithmeticException | MonetaryException e) {
                    continue;
                }
                NumberValue result = mAmount1.getNumber();
                AssertJUnit.assertTrue((String)("Section 4.2.3: Amount's scale is < 0 for " + num + ", was " + result.getScale() + " for " + type.getName()), (0 <= result.getScale() ? 1 : 0) != 0);
            }
        }
    }
}

