/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests;

import java.util.ArrayList;
import java.util.Currency;
import javax.money.CurrencyUnit;
import javax.money.MonetaryCurrencies;
import org.javamoney.tck.TCKTestSetup;
import org.javamoney.tck.TestUtils;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 354", version="1.0.0")
public class ModellingCurrenciesTest {
    @Test(description="4.2.1 Ensure TCK has CurrencyUnit classes configured.")
    @SpecAssertion(section="4.2.1", id="421-A1")
    public void testEnsureCurrencyUnit() {
        AssertJUnit.assertTrue((String)"TCK Configuration not available.", (TCKTestSetup.getTestConfiguration() != null ? 1 : 0) != 0);
        AssertJUnit.assertTrue((TCKTestSetup.getTestConfiguration().getCurrencyClasses().size() > 0 ? 1 : 0) != 0);
    }

    @Test(description="4.2.1 Test currencies provided equal at least currencies from java.util.Currency.")
    @SpecAssertion(section="4.2.1", id="421-A2")
    public void testEqualISOCurrencies() {
        for (Currency currency : Currency.getAvailableCurrencies()) {
            CurrencyUnit unit = MonetaryCurrencies.getCurrency((String)currency.getCurrencyCode(), (String[])new String[0]);
            AssertJUnit.assertNotNull((Object)unit);
            CurrencyUnit unit2 = MonetaryCurrencies.getCurrency((String)currency.getCurrencyCode(), (String[])new String[0]);
            AssertJUnit.assertNotNull((Object)unit2);
            AssertJUnit.assertEquals((Object)unit, (Object)unit2);
        }
    }

    @Test(description="4.2.1 Test currencies provided have correct ISO 3-letter currency codes.")
    @SpecAssertion(section="4.2.1", id="421-A3")
    public void testEnforce3LetterCode4ISO() {
        for (Currency currency : Currency.getAvailableCurrencies()) {
            CurrencyUnit unit = MonetaryCurrencies.getCurrency((String)currency.getCurrencyCode(), (String[])new String[0]);
            AssertJUnit.assertNotNull((Object)unit);
            AssertJUnit.assertEquals((String)currency.getCurrencyCode(), (String)unit.getCurrencyCode());
        }
    }

    @Test(description="4.2.1 Test currencies provided have correct default fraction digits and numeric code.")
    @SpecAssertion(section="4.2.1", id="421-A4")
    public void testISOCodes() {
        for (Currency currency : Currency.getAvailableCurrencies()) {
            CurrencyUnit unit = MonetaryCurrencies.getCurrency((String)currency.getCurrencyCode(), (String[])new String[0]);
            AssertJUnit.assertEquals((String)currency.getCurrencyCode(), (String)unit.getCurrencyCode());
            AssertJUnit.assertEquals((int)currency.getDefaultFractionDigits(), (int)unit.getDefaultFractionDigits());
            AssertJUnit.assertEquals((int)currency.getNumericCode(), (int)unit.getNumericCode());
        }
    }

    @Test(description="4.2.1 Ensure registered CurrencyUnit classes implement hashCode.")
    @SpecAssertion(section="4.2.1", id="421-B1")
    public void testCurrencyClassesEqualsHashcode() {
        for (Class type : TCKTestSetup.getTestConfiguration().getCurrencyClasses()) {
            TestUtils.testHasPublicMethod("Section 4.2.1", type, Integer.TYPE, "hashCode", new Class[0]);
        }
        for (String code : new String[]{"CHF", "USD", "EUR", "GBP", "USS"}) {
            CurrencyUnit unit = MonetaryCurrencies.getCurrency((String)code, (String[])new String[0]);
            TestUtils.testHasPublicMethod("Section 4.2.1", unit.getClass(), Integer.TYPE, "hashCode", new Class[0]);
        }
    }

    @Test(description="4.2.1 Ensure registered CurrencyUnit classes implement equals.")
    @SpecAssertion(section="4.2.1", id="421-B2")
    public void testImplementsEquals() {
        CurrencyUnit unit;
        ArrayList<CurrencyUnit> firstUnits = new ArrayList<CurrencyUnit>();
        ArrayList<CurrencyUnit> secondUnits = new ArrayList<CurrencyUnit>();
        for (String code : new String[]{"CHF", "USD", "EUR", "GBP", "USS"}) {
            unit = MonetaryCurrencies.getCurrency((String)code, (String[])new String[0]);
            AssertJUnit.assertNotNull((Object)unit);
            TestUtils.testHasPublicMethod("Section 4.2.1", unit.getClass(), Boolean.TYPE, "equals", Object.class);
            firstUnits.add(unit);
            CurrencyUnit unit2 = MonetaryCurrencies.getCurrency((String)code, (String[])new String[0]);
            AssertJUnit.assertNotNull((Object)unit2);
            secondUnits.add(unit2);
        }
        for (String code : new String[]{"CHF", "USD", "EUR", "GBP", "USS"}) {
            unit = MonetaryCurrencies.getCurrency((String)code, (String[])new String[0]);
            TestUtils.testHasPublicMethod("Section 4.2.1", unit.getClass(), Boolean.TYPE, "equals", Object.class);
        }
        for (int i = 0; i < firstUnits.size(); ++i) {
            AssertJUnit.assertEquals(firstUnits.get(i), secondUnits.get(i));
        }
    }

    @Test(description="4.2.1 Ensure registered CurrencyUnit classes are Comparable.")
    @SpecAssertion(section="4.2.1", id="421-B3")
    public void testCurrencyClassesComparable() {
        for (Class type : TCKTestSetup.getTestConfiguration().getCurrencyClasses()) {
            TestUtils.testComparable("Section 4.2.1", type);
        }
        for (String code : new String[]{"CHF", "USD", "EUR", "GBP", "USS"}) {
            CurrencyUnit unit = MonetaryCurrencies.getCurrency((String)code, (String[])new String[0]);
            TestUtils.testComparable("Section 4.2.1", unit.getClass());
        }
    }

    @Test(description="4.2.1 Ensure registered CurrencyUnit classes are immutable.")
    @SpecAssertion(section="4.2.1", id="421-B4")
    public void testIsImmutable() {
        for (Class type : TCKTestSetup.getTestConfiguration().getCurrencyClasses()) {
            TestUtils.testImmutable("Section 4.2.1", type);
        }
        for (String code : new String[]{"CHF", "USD", "EUR", "GBP", "USS"}) {
            CurrencyUnit unit = MonetaryCurrencies.getCurrency((String)code, (String[])new String[0]);
            TestUtils.testImmutable("Section 4.2.1", unit.getClass());
        }
    }

    @Test(description="4.2.1 Ensure registered CurrencyUnit classes are serializable.")
    @SpecAssertion(section="4.2.1", id="421-B6")
    public void testImplementsSerializable() {
        for (Class type : TCKTestSetup.getTestConfiguration().getCurrencyClasses()) {
            TestUtils.testSerializable("Section 4.2.1", type);
        }
        for (String code : new String[]{"CHF", "USD", "EUR", "GBP", "USS"}) {
            CurrencyUnit unit = MonetaryCurrencies.getCurrency((String)code, (String[])new String[0]);
            TestUtils.testSerializable("Section 4.2.1", unit);
        }
    }
}

