/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests.conversion;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.NumberValue;
import javax.money.convert.ConversionContext;
import javax.money.convert.ExchangeRate;
import javax.money.convert.RateType;

public class TestExchangeRate
implements ExchangeRate,
Serializable,
Comparable<ExchangeRate> {
    private static final long serialVersionUID = 5077295306570465837L;
    private final CurrencyUnit base;
    private final CurrencyUnit term;
    private final NumberValue factor;
    private final ConversionContext conversionContext;
    private List<ExchangeRate> chain = new ArrayList<ExchangeRate>();

    private TestExchangeRate(Builder builder) {
        Objects.requireNonNull(builder.base, "base may not be null.");
        Objects.requireNonNull(builder.term, "term may not be null.");
        Objects.requireNonNull(builder.factor, "factor may not be null.");
        Objects.requireNonNull(builder.conversionContext, "exchangeRateType may not be null.");
        this.base = builder.base;
        this.term = builder.term;
        this.factor = builder.factor;
        this.conversionContext = builder.conversionContext;
        this.setExchangeRateChain(builder.rateChain);
    }

    private void setExchangeRateChain(List<ExchangeRate> chain) {
        this.chain.clear();
        if (chain == null || chain.isEmpty()) {
            this.chain.add(this);
        } else {
            for (ExchangeRate aChain : chain) {
                if (chain != null) continue;
                throw new IllegalArgumentException("Chain element can not be null.");
            }
            this.chain.addAll(chain);
        }
    }

    public final ConversionContext getConversionContext() {
        return this.conversionContext;
    }

    public final CurrencyUnit getBaseCurrency() {
        return this.base;
    }

    public final CurrencyUnit getCurrency() {
        return this.term;
    }

    public final NumberValue getFactor() {
        return this.factor;
    }

    public final List<ExchangeRate> getExchangeRateChain() {
        return this.chain;
    }

    public final boolean isDerived() {
        return this.chain.size() > 1;
    }

    @Override
    public int compareTo(ExchangeRate o) {
        if (o == null) {
            return -1;
        }
        int compare = this.getBaseCurrency().getCurrencyCode().compareTo(o.getBaseCurrency().getCurrencyCode());
        if (compare == 0) {
            compare = this.getCurrency().getCurrencyCode().compareTo(o.getCurrency().getCurrencyCode());
        }
        if (compare == 0) {
            compare = this.getConversionContext().getProvider().compareTo(o.getConversionContext().getProvider());
        }
        return compare;
    }

    public String toString() {
        return "ExchangeRate [base=" + this.base + ", factor=" + this.factor + ", conversionContext=" + this.conversionContext + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
        result = 31 * result + (this.conversionContext == null ? 0 : this.conversionContext.hashCode());
        result = 31 * result + (this.factor == null ? 0 : this.factor.hashCode());
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        result = 31 * result + (this.chain == null ? 0 : this.chain.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestExchangeRate other = (TestExchangeRate)obj;
        if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
            return false;
        }
        if (!this.chain.equals(other.getExchangeRateChain())) {
            return false;
        }
        if (this.conversionContext == null ? other.conversionContext != null : !this.conversionContext.equals((Object)other.conversionContext)) {
            return false;
        }
        if (this.factor == null ? other.factor != null : !this.factor.equals(other.factor)) {
            return false;
        }
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }

    public Builder toBuilder() {
        return new Builder(this.getConversionContext()).setBase(this.getBaseCurrency()).setTerm(this.getCurrency()).setFactor(this.getFactor()).setRateChain(this.getExchangeRateChain());
    }

    public static class Builder {
        private ConversionContext conversionContext;
        private CurrencyUnit base;
        private CurrencyUnit term;
        private NumberValue factor;
        private List<ExchangeRate> rateChain = new ArrayList<ExchangeRate>();

        public Builder(String provider, RateType rateType) {
            this(ConversionContext.of((String)provider, (RateType)rateType));
        }

        public Builder(ConversionContext context) {
            this.setContext(context);
        }

        public Builder(ExchangeRate rate) {
            this.setContext(rate.getConversionContext());
            this.setFactor(rate.getFactor());
            this.setTerm(rate.getCurrency());
            this.setBase(rate.getBaseCurrency());
            this.setRateChain(rate.getExchangeRateChain());
        }

        public Builder setBase(CurrencyUnit base) {
            this.base = base;
            return this;
        }

        public Builder setTerm(CurrencyUnit term) {
            this.term = term;
            return this;
        }

        public Builder setRateChain(ExchangeRate ... exchangeRates) {
            this.rateChain.clear();
            if (exchangeRates != null) {
                this.rateChain.addAll(Arrays.asList((Object[])exchangeRates.clone()));
            }
            return this;
        }

        public Builder setRateChain(List<ExchangeRate> exchangeRates) {
            this.rateChain.clear();
            if (exchangeRates != null) {
                this.rateChain.addAll(exchangeRates);
            }
            return this;
        }

        public Builder setFactor(NumberValue factor) {
            this.factor = factor;
            return this;
        }

        public Builder setContext(ConversionContext conversionContext) {
            Objects.requireNonNull(conversionContext);
            this.conversionContext = conversionContext;
            return this;
        }

        public TestExchangeRate build() {
            return new TestExchangeRate(this);
        }

        public Builder setRate(ExchangeRate rate) {
            this.base = rate.getBaseCurrency();
            this.term = rate.getCurrency();
            this.conversionContext = rate.getConversionContext();
            this.factor = rate.getFactor();
            this.rateChain = rate.getExchangeRateChain();
            this.term = rate.getCurrency();
            return this;
        }
    }
}

