/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests.internal;

import java.util.Objects;
import javax.money.AbstractContext;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryCurrencies;
import javax.money.convert.ConversionContext;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ConversionQuery;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ExchangeRateProvider;
import javax.money.convert.ProviderContext;
import javax.money.convert.ProviderContextBuilder;
import javax.money.convert.RateType;
import org.javamoney.tck.tests.conversion.TestExchangeRate;
import org.javamoney.tck.tests.internal.TestCurrencyUnit;
import org.javamoney.tck.tests.internal.TestNumberValue;

public class TestRateProvider
implements ExchangeRateProvider {
    private ProviderContext PC = ProviderContextBuilder.of((String)"TestRateProvider", (RateType)RateType.OTHER, (RateType[])new RateType[0]).build();
    private ConversionContext CC = ConversionContextBuilder.create((ProviderContext)this.PC, (RateType)RateType.OTHER).build();
    private CurrencyUnit TERM = new TestCurrencyUnit("FOO");
    private CurrencyConversion CONVERSION = new CurrencyConversion(){

        public CurrencyUnit getCurrency() {
            return TestRateProvider.this.TERM;
        }

        public ConversionContext getConversionContext() {
            return TestRateProvider.this.CC;
        }

        public ExchangeRate getExchangeRate(MonetaryAmount sourceAmount) {
            return new TestExchangeRate.Builder(TestRateProvider.this.CC).setFactor(new TestNumberValue(2)).setBase(sourceAmount.getCurrency()).setTerm(TestRateProvider.this.TERM).build();
        }

        public MonetaryAmount apply(MonetaryAmount value) {
            return value.multiply(2L).getFactory().setCurrency(TestRateProvider.this.TERM).create();
        }
    };

    public ProviderContext getProviderContext() {
        return this.PC;
    }

    public boolean isAvailable(CurrencyUnit base, CurrencyUnit term) {
        Objects.requireNonNull(base);
        Objects.requireNonNull(term);
        return "FOO".equals(term.getCurrencyCode()) || "XXX".equals(term.getCurrencyCode());
    }

    public boolean isAvailable(ConversionQuery conversionContext) {
        Objects.requireNonNull(conversionContext);
        Objects.requireNonNull(conversionContext.getCurrency());
        return "FOO".equals(conversionContext.getCurrency().getCurrencyCode()) || "XXX".equals(conversionContext.getCurrency().getCurrencyCode());
    }

    public boolean isAvailable(String baseCode, String termCode) {
        return "Foo".equals(termCode) || "XXX".equals(termCode);
    }

    public ExchangeRate getExchangeRate(CurrencyUnit base, CurrencyUnit term) {
        if (this.isAvailable(base, term)) {
            return new TestExchangeRate.Builder(this.CC).setFactor(new TestNumberValue(2)).setBase(base).setTerm(term).build();
        }
        return null;
    }

    public ExchangeRate getExchangeRate(ConversionQuery conversionQuery) {
        if (this.isAvailable(conversionQuery)) {
            return new TestExchangeRate.Builder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)this.getProviderContext(), (RateType)RateType.OTHER).importContext((AbstractContext)conversionQuery)).build()).setFactor(new TestNumberValue(2)).setBase(conversionQuery.getBaseCurrency()).setTerm(conversionQuery.getCurrency()).build();
        }
        return null;
    }

    public ExchangeRate getExchangeRate(String baseCode, String termCode) {
        if (this.isAvailable(baseCode, termCode)) {
            return this.getExchangeRate(MonetaryCurrencies.getCurrency((String)baseCode, (String[])new String[0]), this.TERM);
        }
        return null;
    }

    public ExchangeRate getReversed(ExchangeRate rate) {
        return null;
    }

    public CurrencyConversion getCurrencyConversion(CurrencyUnit term) {
        return this.CONVERSION;
    }

    public CurrencyConversion getCurrencyConversion(ConversionQuery conversionQuery) {
        if (this.isAvailable(conversionQuery)) {
            return this.CONVERSION;
        }
        return null;
    }

    public CurrencyConversion getCurrencyConversion(String termCode) {
        if (this.TERM.getCurrencyCode().equals(termCode)) {
            return this.CONVERSION;
        }
        return null;
    }
}

