/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration.pico;

import java.util.ArrayList;
import java.util.List;
import org.jbehave.core.annotations.pico.UsingPico;
import org.jbehave.core.configuration.AnnotationBuilder;
import org.jbehave.core.configuration.AnnotationFinder;
import org.jbehave.core.configuration.AnnotationMonitor;
import org.jbehave.core.configuration.AnnotationRequired;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.pico.PicoModule;
import org.jbehave.core.steps.CompositeStepsFactory;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.pico.PicoStepsFactory;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.injectors.AbstractInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PicoAnnotationBuilder
extends AnnotationBuilder {
    private PicoContainer container;

    public PicoAnnotationBuilder(Class<?> annotatedClass) {
        super(annotatedClass);
    }

    public PicoAnnotationBuilder(Class<?> annotatedClass, AnnotationMonitor annotationMonitor) {
        super(annotatedClass, annotationMonitor);
    }

    public Configuration buildConfiguration() throws AnnotationRequired {
        AnnotationFinder finder = this.annotationFinder();
        if (finder.isAnnotationPresent(UsingPico.class)) {
            List moduleClasses = finder.getAnnotatedValues(UsingPico.class, Class.class, "modules");
            ArrayList<PicoModule> modules = new ArrayList<PicoModule>();
            for (Class moduleClass : moduleClasses) {
                try {
                    modules.add((PicoModule)moduleClass.newInstance());
                }
                catch (Exception e) {
                    this.annotationMonitor().elementCreationFailed(moduleClass, e);
                }
            }
            if (modules.size() > 0) {
                this.container = this.createPicoContainer(modules);
            }
        } else {
            this.annotationMonitor().annotationNotFound(UsingPico.class, (Object)this.annotatedClass());
        }
        return super.buildConfiguration();
    }

    public InjectableStepsFactory buildStepsFactory(Configuration configuration) {
        InjectableStepsFactory factoryUsingSteps = super.buildStepsFactory(configuration);
        if (this.container != null) {
            return new CompositeStepsFactory(new InjectableStepsFactory[]{new PicoStepsFactory(configuration, this.container), factoryUsingSteps});
        }
        return factoryUsingSteps;
    }

    protected ParameterConverters parameterConverters(AnnotationFinder annotationFinder) {
        ParameterConverters converters = super.parameterConverters(annotationFinder);
        if (this.container != null) {
            return converters.addConverters(this.container.getComponents(ParameterConverters.ParameterConverter.class));
        }
        return converters;
    }

    protected <T, V extends T> T instanceOf(Class<T> type, Class<V> ofClass) {
        if (this.container != null) {
            Object instance = null;
            try {
                instance = this.container.getComponent(type);
            }
            catch (AbstractInjector.AmbiguousComponentResolutionException e) {
                instance = this.container.getComponent(ofClass);
            }
            if (instance != null) {
                return (T)instance;
            }
        }
        return (T)super.instanceOf(type, ofClass);
    }

    protected PicoContainer createPicoContainer(List<PicoModule> modules) {
        if (this.container != null) {
            return this.container;
        }
        Class containerClass = (Class)this.annotationFinder().getAnnotatedValue(UsingPico.class, Class.class, "container");
        MutablePicoContainer container = this.instanceOf(MutablePicoContainer.class, containerClass);
        for (PicoModule module : modules) {
            module.configure(container);
        }
        return container;
    }

    protected PicoContainer picoContainer() {
        return this.container;
    }
}

