/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheManager;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.transaction.BatchModeTransactionManager;
import org.jboss.ha.framework.server.CacheManagerLocator;
import org.jboss.ha.framework.server.MarshalledValueHelper;
import org.jboss.ha.framework.server.SimpleCachableMarshalledValue;
import org.jboss.logging.Logger;
import org.jboss.util.loading.ContextClassLoaderSwitcher;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.BatchingManagerImpl;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.CacheListener;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.DistributableSessionDataImpl;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.JBossCacheWrapper;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.PassivationListener;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.Util;
import org.jboss.web.tomcat.service.session.distributedcache.spi.BatchingManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSession;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.SessionSerializationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJBossCacheService
implements DistributedCacheManager {
    public static final String BUDDY_BACKUP = "_BUDDY_BACKUP_";
    public static final Fqn BUDDY_BACKUP_FQN = BuddyManager.BUDDY_BACKUP_SUBTREE_FQN;
    public static final String SESSION = "JSESSION";
    public static final Integer VERSION_KEY = 0;
    public static final Integer TIMESTAMP_KEY = 1;
    public static final Integer METADATA_KEY = 2;
    public static final Integer ATTRIBUTE_KEY = 3;
    protected static final Set<Integer> INTERNAL_KEYS = new HashSet<Integer>(Arrays.asList(VERSION_KEY, TIMESTAMP_KEY, METADATA_KEY, ATTRIBUTE_KEY));
    public static final String FQN_DELIMITER = "/";
    protected Logger log_ = Logger.getLogger(this.getClass());
    private Cache plainCache_;
    protected String combinedPath_;
    protected BatchingManager batchingManager;
    private LocalDistributableSessionManager manager_;
    private ClassLoader webAppClassLoader_;
    private CacheListener cacheListener_;
    protected JBossCacheWrapper cacheWrapper_;
    private boolean useTreeCacheMarshalling_ = false;
    private boolean usePassivation_ = false;
    private PassivationListener passivationListener_;
    private boolean useBuddyReplication_ = false;
    protected String cacheConfigName_;

    public static String getCombinedPath(String hostname, String contextPath) {
        return contextPath + "_" + hostname;
    }

    public static Fqn getSessionFqn(String contextHostPath, String sessionId) {
        Object[] objs = new Object[]{SESSION, contextHostPath, sessionId};
        return Fqn.fromList(Arrays.asList(objs), (boolean)true);
    }

    public static Fqn getBuddyBackupSessionFqn(String dataOwner, String contextHostPath, String sessionId) {
        Object[] objs = new Object[]{BUDDY_BACKUP, dataOwner, SESSION, contextHostPath, sessionId};
        return Fqn.fromList(Arrays.asList(objs), (boolean)true);
    }

    private static ContextClassLoaderSwitcher getContextClassLoaderSwitcher() {
        return (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    }

    protected AbstractJBossCacheService(LocalDistributableSessionManager localManager) throws ClusteringNotSupportedException {
        this(localManager, Util.findPlainCache(Util.getCacheConfigName(localManager)));
        this.cacheConfigName_ = Util.getCacheConfigName(localManager);
    }

    protected AbstractJBossCacheService(LocalDistributableSessionManager localManager, Cache cache) {
        this.manager_ = localManager;
        this.plainCache_ = cache;
        this.cacheWrapper_ = new JBossCacheWrapper(this.plainCache_);
        this.useTreeCacheMarshalling_ = this.plainCache_.getConfiguration().isUseRegionBasedMarshalling();
        CacheLoaderConfig clc = this.plainCache_.getConfiguration().getCacheLoaderConfig();
        if (clc != null) {
            this.usePassivation_ = clc.isPassivation() && !clc.isShared();
        }
    }

    protected LocalDistributableSessionManager getManager() {
        return this.manager_;
    }

    protected Cache getCache() {
        return this.plainCache_;
    }

    protected void setCache(Cache cache) {
        this.plainCache_ = cache;
    }

    protected abstract boolean getStoreAttributesInSingleKey();

    protected abstract boolean isFieldBased();

    public void start() {
        TransactionManager tm;
        this.webAppClassLoader_ = this.manager_.getApplicationClassLoader();
        String path = this.manager_.getContextName();
        String webAppPath = path.length() == 0 || path.equals(FQN_DELIMITER) ? "ROOT" : (path.startsWith(FQN_DELIMITER) ? path.substring(1) : path);
        webAppPath = webAppPath.replace('/', '_');
        this.log_.debug((Object)("Old and new web app path are: " + path + ", " + webAppPath));
        String host = this.manager_.getHostName();
        String hostName = host == null || host.length() == 0 ? "localhost" : host;
        this.log_.debug((Object)("Old and new virtual host name are: " + host + ", " + hostName));
        this.combinedPath_ = AbstractJBossCacheService.getCombinedPath(hostName, webAppPath);
        if (this.plainCache_.getCacheStatus() != CacheStatus.STARTED) {
            this.plainCache_.start();
        }
        if (!((tm = this.plainCache_.getConfiguration().getRuntimeConfig().getTransactionManager()) instanceof BatchModeTransactionManager)) {
            throw new RuntimeException("start(): JBoss Cache transaction manager is not of type BatchModeTransactionManager. It is " + (tm == null ? "null" : tm.getClass().getName()));
        }
        this.batchingManager = new BatchingManagerImpl(tm);
        Object[] objs = new Object[]{SESSION, this.combinedPath_};
        Fqn pathFqn = Fqn.fromList(Arrays.asList(objs), (boolean)true);
        BuddyReplicationConfig brc = this.plainCache_.getConfiguration().getBuddyReplicationConfig();
        boolean bl = this.useBuddyReplication_ = brc != null && brc.isEnabled();
        if (this.useTreeCacheMarshalling_ || this.useBuddyReplication_) {
            this.cleanWebappRegion(pathFqn);
        }
        this.cacheListener_ = new CacheListener(this.cacheWrapper_, this.manager_, this.combinedPath_, Util.getReplicationGranularity(this.manager_));
        this.plainCache_.addCacheListener((Object)this.cacheListener_);
        if (this.useTreeCacheMarshalling_) {
            try {
                this.log_.debug((Object)("UseMarshalling is true. We will register the fqn: " + pathFqn + " with class loader" + this.webAppClassLoader_ + " and activate the webapp's Region"));
                Node root = this.plainCache_.getRoot();
                if (!root.hasChild(pathFqn)) {
                    this.plainCache_.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                    root.addChild(pathFqn);
                }
                Region region = this.plainCache_.getRegion(pathFqn, true);
                region.registerContextClassLoader(this.webAppClassLoader_);
                region.activate();
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't register class loader", ex);
            }
        }
        if (this.manager_.isPassivationEnabled()) {
            this.log_.debug((Object)"Passivation is enabled");
            this.passivationListener_ = new PassivationListener(this.manager_, this.combinedPath_);
            this.plainCache_.addCacheListener((Object)this.passivationListener_);
        } else {
            this.log_.debug((Object)"Passivation is disabled");
        }
    }

    public void stop() {
        BuddyReplicationConfig brc;
        this.plainCache_.removeCacheListener((Object)this.cacheListener_);
        if (this.passivationListener_ != null) {
            this.plainCache_.removeCacheListener((Object)this.passivationListener_);
        }
        Object[] objs = new Object[]{SESSION, this.combinedPath_};
        Fqn pathFqn = Fqn.fromList(Arrays.asList(objs), (boolean)true);
        if (this.useTreeCacheMarshalling_) {
            this.log_.debug((Object)("UseMarshalling is true. We will inactivate the fqn: " + pathFqn + " and un-register its classloader"));
            try {
                Region region = this.plainCache_.getRegion(pathFqn, false);
                if (region != null) {
                    region.deactivate();
                    region.unregisterContextClassLoader();
                }
            }
            catch (Exception e) {
                this.log_.error((Object)("Exception during inactivation of webapp region " + pathFqn + " or un-registration of its class loader"), (Throwable)e);
            }
        }
        boolean bl = this.useBuddyReplication_ = (brc = this.plainCache_.getConfiguration().getBuddyReplicationConfig()) != null && brc.isEnabled();
        if (this.useTreeCacheMarshalling_ || this.useBuddyReplication_) {
            this.cleanWebappRegion(pathFqn);
        }
        this.webAppClassLoader_ = null;
        if (this.cacheConfigName_ != null) {
            this.releaseCacheToManager(this.cacheConfigName_);
        }
    }

    public BatchingManager getBatchingManager() {
        return this.batchingManager;
    }

    public boolean isMarshallingAvailable() {
        return this.useTreeCacheMarshalling_;
    }

    public void sessionCreated(DistributableSession session) {
        if (session.needRegionForSession()) {
            Fqn fqn = AbstractJBossCacheService.getSessionFqn(this.combinedPath_, session.getRealId());
            this.setupSessionRegion(session, fqn);
        }
    }

    public <T extends DistributableSession> T loadSession(String realId, T toLoad) {
        Fqn fqn = AbstractJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        Map sessionData = this.cacheWrapper_.getData(fqn, true);
        if (sessionData == null) {
            return null;
        }
        if (toLoad.needRegionForSession()) {
            this.setupSessionRegion(toLoad, fqn);
        }
        DistributableSessionData dsd = this.getDistributableSessionData(realId, sessionData, true);
        toLoad.update(dsd);
        return toLoad;
    }

    public void putSession(DistributableSession session) {
        String realId = session.getRealId();
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("putSession(): putting session " + realId));
        }
        Fqn fqn = AbstractJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        map.put(VERSION_KEY, session.getVersion());
        boolean replicateTimestamp = false;
        if (session.isSessionMetadataDirty()) {
            map.put(METADATA_KEY, session.getSessionMetadata());
            replicateTimestamp = true;
        }
        if (session.isSessionAttributeMapDirty()) {
            if (this.getStoreAttributesInSingleKey()) {
                Map attrs = session.getSessionAttributeMap();
                map.put(ATTRIBUTE_KEY, this.getMarshalledValue(attrs));
            }
            replicateTimestamp = true;
        }
        if (replicateTimestamp || session.getMustReplicateTimestamp()) {
            map.put(TIMESTAMP_KEY, session.getSessionTimestamp());
        }
        this.cacheWrapper_.put(fqn, map);
    }

    protected void setupSessionRegion(DistributableSession session, Fqn fqn) {
    }

    protected void removeSessionRegion(String realId, Fqn fqn) {
    }

    public void removeSession(String realId) {
        Fqn fqn = AbstractJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("Remove session from distributed store. Fqn: " + fqn));
        }
        this.cacheWrapper_.remove(fqn);
        this.removeSessionRegion(realId, fqn);
    }

    public void removeSessionLocal(String realId) {
        Fqn fqn = AbstractJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("Remove session from my own distributed store only. Fqn: " + fqn));
        }
        this.cacheWrapper_.removeLocal(fqn);
        this.removeSessionRegion(realId, fqn);
    }

    public void removeSessionLocal(String realId, String dataOwner) {
        if (dataOwner == null) {
            this.removeSessionLocal(realId);
        } else {
            Fqn fqn = AbstractJBossCacheService.getBuddyBackupSessionFqn(dataOwner, this.combinedPath_, realId);
            if (this.log_.isTraceEnabled()) {
                this.log_.trace((Object)("Remove session from my own distributed store only. Fqn: " + fqn));
            }
            this.cacheWrapper_.removeLocal(fqn);
        }
    }

    public void evictSession(String realId) {
        this.evictSession(realId, null);
    }

    public void evictSession(String realId, String dataOwner) {
        Fqn fqn;
        Fqn fqn2 = fqn = dataOwner == null ? AbstractJBossCacheService.getSessionFqn(this.combinedPath_, realId) : AbstractJBossCacheService.getBuddyBackupSessionFqn(dataOwner, this.combinedPath_, realId);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("evictSession(): evicting session from my distributed store. Fqn: " + fqn));
        }
        this.cacheWrapper_.evictSubtree(fqn);
    }

    public DistributableSessionData getSessionData(String realId, String dataOwner, boolean includeAttributes) {
        Fqn fqn = dataOwner == null ? AbstractJBossCacheService.getSessionFqn(this.combinedPath_, realId) : AbstractJBossCacheService.getBuddyBackupSessionFqn(dataOwner, this.combinedPath_, realId);
        Map distributedCacheData = this.cacheWrapper_.getData(fqn, false);
        return this.getDistributableSessionData(realId, distributedCacheData, includeAttributes);
    }

    public Map<String, String> getSessionIds() {
        Set owners;
        HashMap<String, String> result = new HashMap<String, String>();
        Fqn webappFqn = this.getWebappFqn();
        Node bbRoot = this.plainCache_.getRoot().getChild(BUDDY_BACKUP_FQN);
        if (bbRoot != null && (owners = bbRoot.getChildren()) != null) {
            for (Node owner : owners) {
                Node webRoot = owner.getChild(webappFqn);
                if (webRoot == null) continue;
                Set ids = webRoot.getChildrenNames();
                this.storeSessionOwners(ids, (String)owner.getFqn().getLastElement(), result);
            }
        }
        this.storeSessionOwners(this.getChildrenNames(webappFqn), null, result);
        return result;
    }

    protected Set getChildrenNames(Fqn fqn) {
        Node node = this.plainCache_.getRoot().getChild(fqn);
        return node == null ? Collections.EMPTY_SET : node.getChildrenNames();
    }

    private void storeSessionOwners(Set<String> ids, String owner, Map<String, String> map) {
        if (ids != null) {
            for (String id : ids) {
                if ("__JBossInternal__".equals(id)) continue;
                map.put(id, owner);
            }
        }
    }

    public boolean isPassivationEnabled() {
        return this.usePassivation_;
    }

    protected Fqn getWebappFqn() {
        Object[] objs = new Object[]{SESSION, this.combinedPath_};
        return Fqn.fromList(Arrays.asList(objs), (boolean)true);
    }

    protected DistributableSessionData getDistributableSessionData(String realId, Map<Object, Object> distributedCacheData, boolean includeAttributes) {
        AtomicInteger version = (AtomicInteger)distributedCacheData.get(VERSION_KEY);
        AtomicLong timestamp = (AtomicLong)distributedCacheData.get(TIMESTAMP_KEY);
        DistributableSessionMetadata metadata = (DistributableSessionMetadata)distributedCacheData.get(METADATA_KEY);
        Map<String, Object> attrs = includeAttributes ? this.getSessionAttributes(realId, distributedCacheData) : null;
        return new DistributableSessionDataImpl(version, timestamp, metadata, attrs);
    }

    protected abstract Map<String, Object> getSessionAttributes(String var1, Map<Object, Object> var2);

    protected void releaseCacheToManager(String cacheConfigName) {
        try {
            CacheManager cm = CacheManagerLocator.getCacheManagerLocator().getCacheManager(null);
            cm.releaseCache(cacheConfigName);
        }
        catch (Exception e) {
            this.log_.error((Object)("Problem releasing cache to CacheManager -- config is " + cacheConfigName), (Throwable)e);
        }
    }

    protected Object getMarshalledValue(Object value) {
        if (MarshalledValueHelper.isTypeExcluded(value.getClass())) {
            return value;
        }
        try {
            SimpleCachableMarshalledValue mv = SessionSerializationFactory.createMarshalledValue((Serializable)((Serializable)value));
            return mv;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(value + " does not implement java.io.Serializable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getUnMarshalledValue(Object obj) {
        if (!(obj instanceof SimpleCachableMarshalledValue)) {
            return obj;
        }
        ContextClassLoaderSwitcher.SwitchContext switcher = null;
        try {
            switcher = AbstractJBossCacheService.getContextClassLoaderSwitcher().getSwitchContext();
            switcher.setClassLoader(this.webAppClassLoader_);
            SimpleCachableMarshalledValue mv = (SimpleCachableMarshalledValue)obj;
            mv.setObjectStreamSource(SessionSerializationFactory.getObjectStreamSource());
            Serializable serializable = mv.get();
            return serializable;
        }
        catch (IOException e) {
            this.log_.error((Object)"IOException occurred unmarshalling value ", (Throwable)e);
            Object var4_7 = null;
            return var4_7;
        }
        catch (ClassNotFoundException e) {
            this.log_.error((Object)"ClassNotFoundException occurred unmarshalling value ", (Throwable)e);
            Object var4_8 = null;
            return var4_8;
        }
        finally {
            if (switcher != null) {
                switcher.reset();
            }
        }
    }

    private void cleanWebappRegion(Fqn regionFqn) {
        try {
            this.plainCache_.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            this.plainCache_.removeNode(regionFqn);
        }
        catch (CacheException e) {
            this.log_.error((Object)"can't clean content from the underlying distributed cache");
        }
    }
}

