/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.singleton.deployer;

import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.Interceptor;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployerWithInput;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.proxy.impl.remoting.ProxyRemotingUtils;
import org.jboss.ejb3.proxy.reflect.ReflectProxyFactory;
import org.jboss.ejb3.singleton.deployer.jndi.Binding;
import org.jboss.ejb3.singleton.deployer.jndi.SingletonBeanJndiBinder;
import org.jboss.ejb3.singleton.proxy.impl.invocationhandler.SingletonBeanLocalInvocationHandler;
import org.jboss.ejb3.singleton.proxy.impl.invocationhandler.SingletonBeanRemoteInvocationHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.LocalBindingMetaData;
import org.jboss.metadata.ejb.jboss.RemoteBindingMetaData;
import org.jboss.metadata.ejb.jboss.jndi.resolver.impl.JNDIPolicyBasedJNDINameResolverFactory;
import org.jboss.metadata.ejb.jboss.jndi.resolver.spi.SessionBean31JNDINameResolver;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.DefaultJNDIBindingPolicyFactory;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;

public class SingletonBeanJNDIBinderDeployer
extends AbstractRealDeployerWithInput<EJBContainer>
implements DeploymentVisitor<EJBContainer> {
    private static final String REMOTE_CLIENT_INTERCEPTOR_STACK_NAME = "SingletonSessionClientInterceptors";
    private static final String LOCAL_CLIENT_INTERCEPTOR_STACK_NAME = "LocalClientInterceptors";
    private static Logger logger = Logger.getLogger(SingletonBeanJNDIBinderDeployer.class);

    public SingletonBeanJNDIBinderDeployer() {
        this.setDeploymentVisitor(this);
        this.setAllInputs(true);
        this.setInput(EJBContainer.class);
        this.setComponentsOnly(true);
        this.addOutput(BeanMetaData.class);
    }

    public void deploy(DeploymentUnit unit, EJBContainer container) throws DeploymentException {
        JBossEnterpriseBeanMetaData enterpriseBean = container.getXml();
        if (!enterpriseBean.isSession()) {
            return;
        }
        JBossSessionBeanMetaData sessionBean = (JBossSessionBeanMetaData)enterpriseBean;
        if (!(sessionBean instanceof JBossSessionBean31MetaData)) {
            return;
        }
        JBossSessionBean31MetaData sessionBean31 = (JBossSessionBean31MetaData)sessionBean;
        if (!sessionBean31.isSingleton()) {
            return;
        }
        this.process(unit, sessionBean31, container);
    }

    public Class<EJBContainer> getVisitorType() {
        return EJBContainer.class;
    }

    public void undeploy(DeploymentUnit unit, EJBContainer deployment) {
    }

    private void process(DeploymentUnit unit, JBossSessionBean31MetaData sessionBean, EJBContainer container) {
        InitialContext initCtx;
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        bindings.addAll(this.processRemoteBusinessInterfaces(unit, sessionBean, container));
        bindings.addAll(this.processLocalBusinessInterfaces(unit, sessionBean, container));
        try {
            initCtx = new InitialContext();
        }
        catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
        SingletonBeanJndiBinder jndiBinder = new SingletonBeanJndiBinder(initCtx, bindings);
        this.createAndAttachJNDIBinerBeanMetaData(unit, jndiBinder, container);
        StringBuilder sb = new StringBuilder("Binding the following entries in JNDI for singleton bean: ");
        sb.append(container.getEjbName());
        sb.append("\n\n");
        for (Binding binding : bindings) {
            sb.append(binding);
            sb.append("\n");
        }
        this.log.info((Object)sb.toString());
    }

    private Collection<Binding> processRemoteBusinessInterfaces(DeploymentUnit unit, JBossSessionBean31MetaData sessionBean, EJBContainer container) {
        BusinessRemotesMetaData businessRemotes = sessionBean.getBusinessRemotes();
        if (businessRemotes == null || businessRemotes.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<Binding> bindings = new HashSet<Binding>();
        String defaultInvokerLocatorURL = ProxyRemotingUtils.getDefaultClientBinding();
        DefaultJndiBindingPolicy jndibindingPolicy = DefaultJNDIBindingPolicyFactory.getDefaultJNDIBindingPolicy();
        SessionBean31JNDINameResolver jndiNameResolver = JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossSessionBean31MetaData)sessionBean, (DefaultJndiBindingPolicy)jndibindingPolicy);
        String containerRegistryKey = container.getObjectName().getCanonicalName();
        String containerGUID = Ejb3Registry.guid((Container)container);
        ReflectProxyFactory proxyFactory = new ReflectProxyFactory();
        Interceptor[] clientInterceptors = this.getRemoteClientInterceptors(container);
        HashSet allRemoteinterfaces = new HashSet();
        for (String businessRemote : businessRemotes) {
            try {
                Class<?> businessRemoteIntf = unit.getClassLoader().loadClass(businessRemote);
                allRemoteinterfaces.add(businessRemoteIntf);
                SingletonBeanRemoteInvocationHandler invocationHandler = new SingletonBeanRemoteInvocationHandler(containerRegistryKey, containerGUID, defaultInvokerLocatorURL, clientInterceptors, businessRemote);
                Object proxy = proxyFactory.createProxy(new Class[]{businessRemoteIntf}, (InvocationHandler)invocationHandler);
                String jndiName = jndiNameResolver.resolveJNDIName((JBossSessionBeanMetaData)sessionBean, businessRemote);
                Binding binding = new Binding(jndiName, proxy, "EJB3.x Remote Business Interface");
                bindings.add(binding);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not load business remote interface " + businessRemote, cnfe);
            }
        }
        List remoteBindings = sessionBean.getRemoteBindings();
        if (remoteBindings == null || remoteBindings.isEmpty()) {
            SingletonBeanRemoteInvocationHandler invocationHandler = new SingletonBeanRemoteInvocationHandler(containerRegistryKey, containerGUID, defaultInvokerLocatorURL, clientInterceptors);
            String defaultRemoteJNDIName = jndiNameResolver.resolveRemoteBusinessDefaultJNDIName((JBossSessionBeanMetaData)sessionBean);
            Object proxy = proxyFactory.createProxy(allRemoteinterfaces.toArray(new Class[allRemoteinterfaces.size()]), (InvocationHandler)invocationHandler);
            Binding binding = new Binding(defaultRemoteJNDIName, proxy, "EJB3.x Default Remote Business Interface");
            bindings.add(binding);
        } else {
            for (RemoteBindingMetaData remoteBinding : remoteBindings) {
                String jndiName = remoteBinding.getJndiName();
                if (jndiName == null) {
                    jndiName = jndiNameResolver.resolveRemoteBusinessDefaultJNDIName((JBossSessionBeanMetaData)sessionBean);
                }
                String invokerLocatorURL = this.getClientBindURL(remoteBinding);
                SingletonBeanRemoteInvocationHandler invocationHandler = new SingletonBeanRemoteInvocationHandler(containerRegistryKey, containerGUID, invokerLocatorURL, clientInterceptors);
                Object proxy = proxyFactory.createProxy(allRemoteinterfaces.toArray(new Class[allRemoteinterfaces.size()]), (InvocationHandler)invocationHandler);
                Binding binding = new Binding(jndiName, proxy, "EJB3.x Default Remote Business Interface");
                bindings.add(binding);
            }
        }
        return bindings;
    }

    private Collection<Binding> processLocalBusinessInterfaces(DeploymentUnit unit, JBossSessionBean31MetaData sessionBean, EJBContainer container) {
        Binding binding;
        BusinessLocalsMetaData businessLocals = sessionBean.getBusinessLocals();
        if (businessLocals == null || businessLocals.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<Binding> bindings = new HashSet<Binding>();
        DefaultJndiBindingPolicy jndibindingPolicy = DefaultJNDIBindingPolicyFactory.getDefaultJNDIBindingPolicy();
        SessionBean31JNDINameResolver jndiNameResolver = JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossSessionBean31MetaData)sessionBean, (DefaultJndiBindingPolicy)jndibindingPolicy);
        String containerRegistryKey = container.getObjectName().getCanonicalName();
        String containerGUID = Ejb3Registry.guid((Container)container);
        ReflectProxyFactory proxyFactory = new ReflectProxyFactory();
        HashSet allLocalinterfaces = new HashSet();
        Interceptor[] clientInterceptors = this.getLocalClientInterceptors(container);
        for (String businessLocal : businessLocals) {
            Class<?> businessLocalIntf = null;
            try {
                businessLocalIntf = unit.getClassLoader().loadClass(businessLocal);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not load business local interface " + businessLocal, cnfe);
            }
            allLocalinterfaces.add(businessLocalIntf);
            SingletonBeanLocalInvocationHandler invocationHandler = new SingletonBeanLocalInvocationHandler(containerRegistryKey, containerGUID, businessLocal, clientInterceptors);
            Object proxy = proxyFactory.createProxy(new Class[]{businessLocalIntf}, (InvocationHandler)invocationHandler);
            String jndiName = jndiNameResolver.resolveJNDIName((JBossSessionBeanMetaData)sessionBean, businessLocal);
            binding = new Binding(jndiName, proxy, "EJB3.x Local Business Interface");
            bindings.add(binding);
        }
        List localBindings = sessionBean.getLocalBindings();
        if (localBindings == null || localBindings.isEmpty()) {
            SingletonBeanLocalInvocationHandler invocationHandler = new SingletonBeanLocalInvocationHandler(containerRegistryKey, containerGUID, clientInterceptors);
            String defaultBusinessLocalJNDIName = jndiNameResolver.resolveLocalBusinessDefaultJNDIName((JBossSessionBeanMetaData)sessionBean);
            Object proxy = proxyFactory.createProxy(allLocalinterfaces.toArray(new Class[allLocalinterfaces.size()]), (InvocationHandler)invocationHandler);
            Binding binding2 = new Binding(defaultBusinessLocalJNDIName, proxy, "EJB3.x Default Local Business Interface");
            bindings.add(binding2);
        } else {
            for (LocalBindingMetaData localBinding : localBindings) {
                String jndiName = localBinding.getJndiName();
                if (jndiName == null) {
                    jndiName = jndiNameResolver.resolveLocalBusinessDefaultJNDIName((JBossSessionBeanMetaData)sessionBean);
                }
                SingletonBeanLocalInvocationHandler invocationHandler = new SingletonBeanLocalInvocationHandler(containerRegistryKey, containerGUID, clientInterceptors);
                Object proxy = proxyFactory.createProxy(allLocalinterfaces.toArray(new Class[allLocalinterfaces.size()]), (InvocationHandler)invocationHandler);
                binding = new Binding(jndiName, proxy, "EJB3.x Default Local Business Interface");
                bindings.add(binding);
            }
        }
        return bindings;
    }

    private String getClientBindURL(RemoteBindingMetaData remoteBinding) {
        String explicitClientBindURL;
        String invokerName = remoteBinding.getInvokerName();
        String generatedClientBindURL = null;
        if (invokerName != null && !invokerName.trim().isEmpty()) {
            invokerName = invokerName.trim();
            generatedClientBindURL = ProxyRemotingUtils.getClientBinding((String)invokerName);
        }
        if ((explicitClientBindURL = remoteBinding.getClientBindUrl()) != null && explicitClientBindURL.trim().isEmpty()) {
            explicitClientBindURL = null;
        }
        if (explicitClientBindURL != null && generatedClientBindURL != null) {
            logger.warn((Object)("Both invokerName and clientBindURL specified on RemoteBinding. Ignoring the explicitly specified bind url " + explicitClientBindURL + " and instead using " + generatedClientBindURL));
        }
        String bindURL = generatedClientBindURL == null ? explicitClientBindURL : generatedClientBindURL;
        return bindURL == null ? ProxyRemotingUtils.getDefaultClientBinding() : bindURL;
    }

    private Interceptor[] getRemoteClientInterceptors(EJBContainer container) {
        AspectManager manager = AspectManager.instance();
        AdviceStack stack = manager.getAdviceStack(REMOTE_CLIENT_INTERCEPTOR_STACK_NAME);
        if (stack == null) {
            throw new RuntimeException("Could not find Advice Stack with name: SingletonSessionClientInterceptors");
        }
        Interceptor[] interceptors = stack.createInterceptors(container.getAdvisor(), null);
        return interceptors;
    }

    private Interceptor[] getLocalClientInterceptors(EJBContainer container) {
        AspectManager manager = AspectManager.instance();
        AdviceStack stack = manager.getAdviceStack(LOCAL_CLIENT_INTERCEPTOR_STACK_NAME);
        if (stack == null) {
            throw new RuntimeException("Could not find Advice Stack with name: LocalClientInterceptors");
        }
        Interceptor[] interceptors = stack.createInterceptors(container.getAdvisor(), null);
        return interceptors;
    }

    private void createAndAttachJNDIBinerBeanMetaData(DeploymentUnit unit, SingletonBeanJndiBinder jndiBinder, EJBContainer container) {
        String containerName = container.getXml().getContainerName();
        String binderName = containerName + ",type=singleton-bean-jndi-binder";
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)binderName, (String)jndiBinder.getClass().getName());
        builder.setConstructorValue((Object)jndiBinder);
        builder.addDemand((Object)containerName, ControllerState.START, ControllerState.START, null);
        for (Binding binding : jndiBinder.getBindings()) {
            builder.addSupply((Object)("jndi:" + binding.getJndiName()));
        }
        if (unit.isComponent()) {
            unit.getParent().addAttachment(BeanMetaData.class + ":" + binderName, (Object)builder.getBeanMetaData());
        } else {
            unit.addAttachment(BeanMetaData.class + ":" + binderName, (Object)builder.getBeanMetaData());
        }
    }
}

