/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.deployers;

import java.util.ArrayList;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.api.annotations.MapValue;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.jpa.deployment.PersistenceUnitDeployment;
import org.jboss.jpa.resolvers.DataSourceDependencyResolver;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.metadata.jpa.spec.PersistenceUnitMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitDeployer
extends AbstractSimpleRealDeployer<PersistenceUnitMetaData> {
    private Properties defaultPersistenceProperties;
    private DataSourceDependencyResolver dataSourceDependencyResolver;
    private PersistenceUnitDependencyResolver persistenceUnitDependencyResolver;

    public PersistenceUnitDeployer() {
        super(PersistenceUnitMetaData.class);
        this.setComponentsOnly(true);
        this.addOutput(BeanMetaData.class);
    }

    private void addDependencies(BeanMetaDataBuilder builder, PersistenceUnitMetaData metaData) {
        Properties props = this.defaultPersistenceProperties;
        if (!props.containsKey("jboss.no.implicit.datasource.dependency")) {
            String ds;
            if (metaData.getJtaDataSource() != null) {
                ds = metaData.getJtaDataSource();
                builder.addDependency((Object)this.dataSourceDependencyResolver.resolveDataSourceSupplier(ds));
            }
            if (metaData.getNonJtaDataSource() != null) {
                ds = metaData.getNonJtaDataSource();
                builder.addDependency((Object)this.dataSourceDependencyResolver.resolveDataSourceSupplier(ds));
            }
        }
        for (Object prop : props.keySet()) {
            String property = (String)prop;
            if (!property.startsWith("jboss.depends")) continue;
            builder.addDependency(props.get(property));
        }
    }

    public void deploy(DeploymentUnit unit, PersistenceUnitMetaData metaData) throws DeploymentException {
        this.log.debug((Object)("deploy " + metaData));
        try {
            String name = this.persistenceUnitDependencyResolver.createBeanName(unit, metaData.getName());
            InitialContext initialContext = new InitialContext();
            ArrayList<String> explicitEntityClasses = new ArrayList<String>();
            VFSDeploymentUnit deploymentUnit = (VFSDeploymentUnit)unit.getParent();
            PersistenceUnitDeployment pu = new PersistenceUnitDeployment(initialContext, null, explicitEntityClasses, metaData, name, deploymentUnit, this.defaultPersistenceProperties);
            AbstractBeanMetaData beanMetaData = new AbstractBeanMetaData(name, PersistenceUnitDeployment.class.getName());
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((BeanMetaData)beanMetaData);
            builder.setConstructorValue((Object)pu);
            this.addDependencies(builder, metaData);
            DeploymentUnit parent = unit.getParent();
            if (parent == null) {
                throw new IllegalArgumentException("Parent unit should not be null as this unit should be component: " + unit);
            }
            parent.addAttachment(BeanMetaData.class.getName() + "." + name, (Object)builder.getBeanMetaData(), BeanMetaData.class);
        }
        catch (NamingException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    @Inject
    public void setDataSourceDependencyResolver(DataSourceDependencyResolver resolver) {
        this.dataSourceDependencyResolver = resolver;
    }

    @MapValue(keyClass=String.class, value={}, valueClass=String.class)
    public void setDefaultPersistenceProperties(Properties p) {
        this.defaultPersistenceProperties = p;
    }

    @Inject
    public void setPersistenceUnitDependencyResolver(PersistenceUnitDependencyResolver resolver) {
        this.persistenceUnitDependencyResolver = resolver;
    }
}

