/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.integration;

import org.jboss.aop.microcontainer.annotations.DisableAOP;
import org.jboss.aop.microcontainer.annotations.DisabledType;
import org.jboss.aop.microcontainer.annotations.EnableAopAnnotationDependency;
import org.jboss.aop.microcontainer.annotations.EnableAopProxy;
import org.jboss.metadata.spi.MetaData;

public final class DisableAOPHelper {
    public static boolean isAOPDisabled(MetaData metaData, DisabledType constraint) {
        if (metaData != null) {
            if (constraint == DisabledType.POINTCUTS) {
                EnableAopProxy proxy = (EnableAopProxy)metaData.getAnnotation(EnableAopProxy.class);
                return proxy == null;
            }
            if (constraint == DisabledType.ANNOTATION_DEPENDENCIES) {
                EnableAopAnnotationDependency proxy = (EnableAopAnnotationDependency)metaData.getAnnotation(EnableAopAnnotationDependency.class);
                return proxy == null;
            }
            if (constraint == DisabledType.ALL) {
                Boolean legacyDisabled = null;
                DisableAOP aop = (DisableAOP)metaData.getAnnotation(DisableAOP.class);
                if (aop != null) {
                    legacyDisabled = DisabledType.isDisabled(aop.value(), constraint);
                }
                if (legacyDisabled != null) {
                    return legacyDisabled;
                }
                return false;
            }
        }
        return true;
    }
}

