/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guava;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.util.Objects;
import org.assertj.guava.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.mapper.reflect.ConstructorMapper;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.guava.GuavaPlugin;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MultimapEntryMapperTest {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugin((JdbiPlugin)new GuavaPlugin());
    private Handle h;

    @Before
    public void setUp() {
        this.h = this.dbRule.getSharedHandle();
    }

    @Test
    public void keyValueColumns() {
        this.h.execute("create table config (key varchar, value varchar)", new Object[0]);
        this.h.prepareBatch("insert into config (key, value) values (?, ?)").add(new Object[]{"foo", "123"}).add(new Object[]{"foo", "456"}).add(new Object[]{"bar", "xyz"}).execute();
        Multimap map = (Multimap)((Query)((Query)this.h.createQuery("select key, value from config").setMapKeyColumn("key")).setMapValueColumn("value")).collectInto((GenericType)new GenericType<Multimap<String, String>>(){});
        ImmutableListMultimap expected = ImmutableListMultimap.builder().putAll((Object)"foo", (Object[])new String[]{"123", "456"}).put((Object)"bar", (Object)"xyz").build();
        Assertions.assertThat((Multimap)map).isEqualTo((Object)expected);
    }

    @Test
    public void index() {
        this.h.execute("create table user (id int, manager_id int, name varchar)", new Object[0]);
        this.h.prepareBatch("insert into user (id, manager_id, name) values (?, ?, ?)").add(new Object[]{1, 0, "alice"}).add(new Object[]{2, 1, "bob"}).add(new Object[]{3, 1, "cathy"}).add(new Object[]{4, 3, "dilbert"}).execute();
        Multimap map = (Multimap)((Query)((Query)this.h.createQuery("select id, manager_id, name from user").setMapKeyColumn("manager_id")).registerRowMapper(ConstructorMapper.factory(User.class))).collectInto((GenericType)new GenericType<Multimap<Integer, User>>(){});
        ImmutableListMultimap expected = ImmutableListMultimap.builder().put((Object)0, (Object)new User(1, "alice")).putAll((Object)1, (Object[])new User[]{new User(2, "bob"), new User(3, "cathy")}).put((Object)3, (Object)new User(4, "dilbert")).build();
        Assertions.assertThat((Multimap)map).isEqualTo((Object)expected);
    }

    @Test
    public void joinRow() {
        this.h.execute("create table user (id int, name varchar)", new Object[0]);
        this.h.execute("create table phone (id int, user_id int, phone varchar)", new Object[0]);
        this.h.prepareBatch("insert into user (id, name) values (?, ?)").add(new Object[]{1, "alice"}).add(new Object[]{2, "bob"}).execute();
        this.h.prepareBatch("insert into phone (id, user_id, phone) values (?, ?, ?)").add(new Object[]{10, 1, "555-0001"}).add(new Object[]{11, 1, "555-0002"}).add(new Object[]{20, 2, "555-0003"}).execute();
        String sql = "select u.id u_id, u.name u_name, p.id p_id, p.phone p_phone from user u left join phone p on u.id = p.user_id";
        Multimap map = (Multimap)((Query)((Query)this.h.createQuery(sql).registerRowMapper(ConstructorMapper.factory(User.class, (String)"u"))).registerRowMapper(ConstructorMapper.factory(Phone.class, (String)"p"))).collectInto((GenericType)new GenericType<Multimap<User, Phone>>(){});
        ImmutableListMultimap expected = ImmutableListMultimap.builder().putAll((Object)new User(1, "alice"), (Object[])new Phone[]{new Phone(10, "555-0001"), new Phone(11, "555-0002")}).put((Object)new User(2, "bob"), (Object)new Phone(20, "555-0003")).build();
        Assertions.assertThat((Multimap)map).isEqualTo((Object)expected);
    }

    public static class Phone {
        private final int id;
        private final String phone;

        public Phone(int id, String phone) {
            this.id = id;
            this.phone = phone;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Phone phone1 = (Phone)o;
            return this.id == phone1.id && Objects.equals(this.phone, phone1.phone);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.phone);
        }

        public String toString() {
            return "Phone{id=" + this.id + ", phone='" + this.phone + '\'' + '}';
        }
    }

    public static class User {
        private final int id;
        private final String name;

        public User(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            return this.id == user.id && Objects.equals(this.name, user.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }

        public String toString() {
            return "User{id=" + this.id + ", name='" + this.name + '\'' + '}';
        }
    }
}

