/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guava;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.guava.api.MultimapAssert;
import org.jdbi.v3.core.collector.JdbiCollectors;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestGuavaCollectors {
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugins();
    private Collection<Integer> expected;

    @Before
    public void addData() {
        ImmutableList.Builder expected = ImmutableList.builder();
        for (int i = 0; i < 10; ++i) {
            this.dbRule.getSharedHandle().execute("insert into something(name, intValue) values (?, ?)", new Object[]{Integer.toString(i), i});
            expected.add((Object)i);
        }
        this.expected = expected.build();
    }

    @Test
    public void immutableList() {
        ImmutableList list = (ImmutableList)this.dbRule.getSharedHandle().createQuery("select intValue from something").collectInto((GenericType)new GenericType<ImmutableList<Integer>>(){});
        Assertions.assertThat((List)list).containsOnlyElementsOf(this.expected);
    }

    @Test
    public void immutableSet() {
        ImmutableSet set = (ImmutableSet)this.dbRule.getSharedHandle().createQuery("select intValue from something").collectInto((GenericType)new GenericType<ImmutableSet<Integer>>(){});
        Assertions.assertThat((Iterable)set).containsOnlyElementsOf(this.expected);
    }

    @Test
    public void immutableSortedSet() {
        ImmutableSortedSet set = (ImmutableSortedSet)this.dbRule.getSharedHandle().createQuery("select intValue from something").collectInto((GenericType)new GenericType<ImmutableSortedSet<Integer>>(){});
        Assertions.assertThat((Iterable)set).containsExactlyElementsOf(this.expected);
    }

    @Test
    public void immutableSortedSetWithComparator() {
        Comparator comparator = Comparator.naturalOrder().reversed();
        ImmutableSortedSet set = (ImmutableSortedSet)this.dbRule.getSharedHandle().createQuery("select intValue from something").mapTo(Integer.TYPE).collect(ImmutableSortedSet.toImmutableSortedSet(comparator));
        Assertions.assertThat((Iterable)set).containsExactlyElementsOf((Iterable)this.expected.stream().sorted(comparator).collect(Collectors.toList()));
    }

    @Test
    public void optionalPresent() {
        com.google.common.base.Optional shouldBePresent = (com.google.common.base.Optional)this.dbRule.getSharedHandle().createQuery("select intValue from something where intValue = 1").collectInto((GenericType)new GenericType<com.google.common.base.Optional<Integer>>(){});
        org.assertj.guava.api.Assertions.assertThat((com.google.common.base.Optional)shouldBePresent).contains((Object)1);
    }

    @Test
    public void optionalAbsent() {
        com.google.common.base.Optional shouldBeAbsent = (com.google.common.base.Optional)this.dbRule.getSharedHandle().createQuery("select intValue from something where intValue = 100").collectInto((GenericType)new GenericType<com.google.common.base.Optional<Integer>>(){});
        org.assertj.guava.api.Assertions.assertThat((com.google.common.base.Optional)shouldBeAbsent).isAbsent();
    }

    @Test(expected=IllegalStateException.class)
    public void optionalMultiple() {
        this.dbRule.getSharedHandle().createQuery("select intValue from something").collectInto((GenericType)new GenericType<com.google.common.base.Optional<Integer>>(){});
    }

    @Test
    public void mapCollectors() {
        this.testMapCollector(ImmutableMap.class, new GenericType<ImmutableMap<Long, String>>(){});
        this.testMapCollector(BiMap.class, new GenericType<BiMap<Long, String>>(){});
    }

    private <M extends Map<Long, String>> void testMapCollector(Class<? extends Map> erasedType, GenericType<M> genericType) {
        JdbiCollectors registry = (JdbiCollectors)this.dbRule.getJdbi().getConfig(JdbiCollectors.class);
        Assertions.assertThat((Optional)registry.findElementTypeFor(genericType.getType())).contains((Object)new GenericType<Map.Entry<Long, String>>(){}.getType());
        Collector collector = (Collector)registry.findFor(genericType.getType()).orElseThrow(() -> new IllegalStateException("Missing collector for " + genericType));
        Map map = (Map)Stream.of(org.assertj.guava.api.Assertions.entry((Object)1L, (Object)"foo"), org.assertj.guava.api.Assertions.entry((Object)2L, (Object)"bar")).collect(collector);
        ((MapAssert)Assertions.assertThat((Map)map).isInstanceOf(erasedType)).containsExactly(new Map.Entry[]{org.assertj.guava.api.Assertions.entry((Object)1L, (Object)"foo"), org.assertj.guava.api.Assertions.entry((Object)2L, (Object)"bar")});
    }

    @Test
    public void multimapCollectors() {
        this.testMultimapCollector(ImmutableMultimap.class, new GenericType<ImmutableMultimap<Long, String>>(){});
        this.testMultimapCollector(ImmutableListMultimap.class, new GenericType<ImmutableListMultimap<Long, String>>(){});
        this.testMultimapCollector(ImmutableSetMultimap.class, new GenericType<ImmutableSetMultimap<Long, String>>(){});
        this.testMultimapCollector(Multimap.class, new GenericType<Multimap<Long, String>>(){});
        this.testMultimapCollector(ListMultimap.class, new GenericType<ListMultimap<Long, String>>(){});
        this.testMultimapCollector(ArrayListMultimap.class, new GenericType<ArrayListMultimap<Long, String>>(){});
        this.testMultimapCollector(LinkedListMultimap.class, new GenericType<LinkedListMultimap<Long, String>>(){});
        this.testMultimapCollector(SetMultimap.class, new GenericType<SetMultimap<Long, String>>(){});
        this.testMultimapCollector(HashMultimap.class, new GenericType<HashMultimap<Long, String>>(){});
        this.testMultimapCollector(TreeMultimap.class, new GenericType<TreeMultimap<Long, String>>(){});
    }

    private <M extends Multimap<Long, String>> void testMultimapCollector(Class<? extends Multimap> erasedType, GenericType<M> genericType) {
        JdbiCollectors registry = (JdbiCollectors)this.dbRule.getJdbi().getConfig(JdbiCollectors.class);
        Assertions.assertThat((Optional)registry.findElementTypeFor(genericType.getType())).contains((Object)new GenericType<Map.Entry<Long, String>>(){}.getType());
        Collector collector = (Collector)registry.findFor(genericType.getType()).orElseThrow(() -> new IllegalStateException("Missing collector for " + genericType));
        Multimap map = (Multimap)Stream.of(org.assertj.guava.api.Assertions.entry((Object)1L, (Object)"foo"), org.assertj.guava.api.Assertions.entry((Object)2L, (Object)"bar")).collect(collector);
        ((MultimapAssert)org.assertj.guava.api.Assertions.assertThat((Multimap)map).isInstanceOf(erasedType)).containsAllEntriesOf((Multimap)ImmutableMultimap.of((Object)1L, (Object)"foo", (Object)2L, (Object)"bar"));
    }
}

