/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guava;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.rule.PgDatabaseRule;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.guava.GuavaPlugin;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TestGuavaMappers {
    @Rule
    public PgDatabaseRule dbRule = new PgDatabaseRule().withPlugin((JdbiPlugin)new GuavaPlugin());
    private Handle h;

    @Before
    public void setUp() {
        ((Jdbi)this.dbRule.getJdbi().registerArrayType(Integer.class, "integer")).registerArrayType(UUID.class, "uuid");
        this.h = this.dbRule.openHandle();
        this.h.useTransaction(th -> {
            th.execute("DROP TABLE IF EXISTS arrays", new Object[0]);
            th.execute("CREATE TABLE arrays (u UUID[], i INT[])", new Object[0]);
        });
    }

    @Test
    public void testUuidImmutableList() throws Exception {
        Object[] testUuids = new UUID[]{UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID()};
        this.h.execute("INSERT INTO arrays (u) VALUES(?)", new Object[]{testUuids});
        ImmutableList list = (ImmutableList)this.h.createQuery("SELECT u FROM arrays").mapTo((GenericType)new GenericType<ImmutableList<UUID>>(){}).findOnly();
        Assertions.assertThat((List)list).contains(testUuids);
    }

    @Test
    public void testIntegerImmutableList() throws Exception {
        Object[] testInts = new Integer[]{5, 4, -6, 1, 9, Integer.MAX_VALUE, Integer.MIN_VALUE};
        this.h.execute("INSERT INTO arrays (i) VALUES(?)", new Object[]{testInts});
        ImmutableList list = (ImmutableList)this.h.createQuery("SELECT i FROM arrays").mapTo((GenericType)new GenericType<ImmutableList<Integer>>(){}).findOnly();
        Assertions.assertThat((List)list).contains(testInts);
    }
}

