/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guava;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Something;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.rule.H2DatabaseRule;
import org.jdbi.v3.core.statement.Query;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestGuavaOptional {
    private static final String SELECT_BY_NAME = "select * from something where :name is null or name = :name order by id";
    @Rule
    public H2DatabaseRule dbRule = new H2DatabaseRule().withPlugins();
    @Rule
    public ExpectedException exception = ExpectedException.none();
    Handle handle;

    @Before
    public void createTestData() {
        this.handle = this.dbRule.openHandle();
        this.handle.createUpdate("insert into something (id, name) values (1, 'eric')").execute();
        this.handle.createUpdate("insert into something (id, name) values (2, 'brian')").execute();
    }

    @Test
    public void testDynamicBindOptionalPresent() throws Exception {
        Something result = (Something)((Query)this.handle.createQuery(SELECT_BY_NAME).bindByType("name", (Object)com.google.common.base.Optional.of((Object)"eric"), (GenericType)new GenericType<com.google.common.base.Optional<String>>(){})).mapToBean(Something.class).findOnly();
        Assertions.assertThat((Object)result).isEqualTo((Object)new Something(1, "eric"));
    }

    @Test
    public void testDynamicBindOptionalEmpty() throws Exception {
        List result = ((Query)this.handle.createQuery(SELECT_BY_NAME).bindByType("name", (Object)com.google.common.base.Optional.absent(), (GenericType)new GenericType<com.google.common.base.Optional<String>>(){})).mapToBean(Something.class).list();
        Assertions.assertThat((List)result).containsExactly((Object[])new Something[]{new Something(1, "eric"), new Something(2, "brian")});
    }

    @Test
    public void testDynamicBindOptionalOfCustomType() throws Exception {
        this.handle.registerArgument((ArgumentFactory)new NameArgumentFactory());
        ((Query)this.handle.createQuery(SELECT_BY_NAME).bindByType("name", (Object)com.google.common.base.Optional.of((Object)new Name("eric")), (GenericType)new GenericType<com.google.common.base.Optional<Name>>(){})).mapToBean(Something.class).list();
    }

    @Test
    public void testDynamicBindOptionalOfUnregisteredCustomType() throws Exception {
        this.exception.expect(UnsupportedOperationException.class);
        ((Query)this.handle.createQuery(SELECT_BY_NAME).bindByType("name", (Object)com.google.common.base.Optional.of((Object)new Name("eric")), (GenericType)new GenericType<com.google.common.base.Optional<Name>>(){})).mapToBean(Something.class).list();
    }

    @Test
    public void testBindOptionalPresent() throws Exception {
        Something result = (Something)((Query)this.handle.createQuery(SELECT_BY_NAME).bind("name", (Object)com.google.common.base.Optional.of((Object)"brian"))).mapToBean(Something.class).findOnly();
        Assertions.assertThat((Object)result).isEqualTo((Object)new Something(2, "brian"));
    }

    @Test
    public void testBindOptionalEmpty() throws Exception {
        List result = ((Query)this.handle.createQuery(SELECT_BY_NAME).bind("name", (Object)com.google.common.base.Optional.absent())).mapToBean(Something.class).list();
        Assertions.assertThat((List)result).containsExactly((Object[])new Something[]{new Something(1, "eric"), new Something(2, "brian")});
    }

    @Test
    public void testBindOptionalOfCustomType() throws Exception {
        this.handle.registerArgument((ArgumentFactory)new NameArgumentFactory());
        List result = ((Query)this.handle.createQuery(SELECT_BY_NAME).bind("name", (Object)com.google.common.base.Optional.of((Object)new Name("eric")))).mapToBean(Something.class).list();
        Assertions.assertThat((List)result).containsExactly((Object[])new Something[]{new Something(1, "eric")});
    }

    @Test
    public void testBindOptionalOfUnregisteredCustomType() throws Exception {
        this.exception.expect(UnsupportedOperationException.class);
        ((Query)this.handle.createQuery(SELECT_BY_NAME).bind("name", (Object)com.google.common.base.Optional.of((Object)new Name("eric")))).mapToBean(Something.class).list();
    }

    class NameArgumentFactory
    implements ArgumentFactory {
        NameArgumentFactory() {
        }

        public Optional<Argument> build(Type expectedType, Object value, ConfigRegistry config) {
            if (expectedType == Name.class) {
                Name nameValue = (Name)value;
                return Optional.of((pos, stmt, c) -> stmt.setString(pos, nameValue.value));
            }
            return Optional.empty();
        }
    }

    class Name {
        final String value;

        Name(String value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Name)) {
                return false;
            }
            Name that = (Name)obj;
            return this.value.equals(that.value);
        }
    }
}

