/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.json;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.json.Json;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.junit.Test;

public abstract class AbstractJsonMapperTest {
    protected Jdbi jdbi;

    @Test
    public void testSqlObject() {
        this.jdbi.useHandle(h -> {
            h.execute("create table subjects (id serial primary key, subject json not null)", new Object[0]);
            JsonDao dao = (JsonDao)h.attach(JsonDao.class);
            dao.insert(new JsonBean("yams", 42));
            dao.insert(new JsonBean("apples", 24));
            Assertions.assertThat(dao.select()).extracting(new String[]{"food", "bitcoins"}).containsExactlyInAnyOrder((Object[])new Tuple[]{new Tuple(new Object[]{"yams", 42}), new Tuple(new Object[]{"apples", 24})});
        });
    }

    @Test
    public void testFluentApi() {
        this.jdbi.useHandle(h -> {
            h.execute("create table subjects (id serial primary key, subject json not null)", new Object[0]);
            JsonBean in = new JsonBean("nom", 10);
            ((Update)h.createUpdate("insert into subjects(id, subject) values(1, :bean)").bindByType("bean", (Object)in, QualifiedType.of(JsonBean.class).with(new Class[]{Json.class}))).execute();
            JsonBean out = (JsonBean)h.createQuery("select subject from subjects").mapTo(QualifiedType.of(JsonBean.class).with(new Class[]{Json.class})).one();
            Assertions.assertThat((Object)out).isEqualTo((Object)in);
        });
    }

    @Test
    public void testFluentApiWithNesting() {
        this.jdbi.useHandle(h -> {
            h.execute("create table bean (id serial primary key, nested1 json, nested2 json)", new Object[0]);
            Assertions.assertThat((int)((Update)h.createUpdate("insert into bean(id, nested1, nested2) values (:id, :nested1, :nested2)").bindBean((Object)new NestedJsonBean(42, 64, "quux"))).execute()).isEqualTo(1);
            NestedJsonBean beany = (NestedJsonBean)h.createQuery("select * from bean").mapToBean(NestedJsonBean.class).one();
            Assertions.assertThat((int)beany.getId()).isEqualTo(42);
            Assertions.assertThat((int)beany.getNested1().getA()).isEqualTo(64);
            Assertions.assertThat((String)beany.getNested2().getA()).isEqualTo((Object)"quux");
        });
    }

    @Test
    public void testNull() {
        this.jdbi.useHandle(h -> {
            h.execute("create table subjects (id serial primary key, subject json)", new Object[0]);
            JsonDao dao = (JsonDao)h.attach(JsonDao.class);
            dao.insert(null);
            Assertions.assertThat((String)((String)h.createQuery("select subject from subjects").mapTo(String.class).one())).isNull();
            Assertions.assertThat(dao.select()).containsExactly((Object[])new JsonBean[]{null});
        });
    }

    @Test
    public void testOptionalNull() {
        this.jdbi.useHandle(h -> {
            h.execute("create table subjects (id serial primary key, subject json)", new Object[0]);
            JsonDao dao = (JsonDao)h.attach(JsonDao.class);
            dao.insertOptional(Optional.empty());
            dao.insert(null);
            Assertions.assertThat(dao.selectOptional()).containsExactly((Object[])new Optional[]{Optional.empty(), Optional.empty()});
            Assertions.assertThat((List)h.createQuery("select subject from subjects").mapTo(String.class).list()).containsExactly((Object[])new String[]{null, null});
        });
    }

    public static class Nested2 {
        private final String a;
        private final int b;

        public Nested2(String a, int b) {
            this.a = a;
            this.b = b;
        }

        public String getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }
    }

    public static class Nested1 {
        private final int a;
        private final String b;

        public Nested1(int a, String b) {
            this.a = a;
            this.b = b;
        }

        public int getA() {
            return this.a;
        }

        public String getB() {
            return this.b;
        }
    }

    public static class NestedJsonBean {
        private int id;
        private Nested1 nested1;
        private Nested2 nested2;

        public NestedJsonBean() {
        }

        private NestedJsonBean(int id, int a, String b) {
            this.id = id;
            this.nested1 = new Nested1(a, "1");
            this.nested2 = new Nested2(b, 2);
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        @Json
        public Nested1 getNested1() {
            return this.nested1;
        }

        public void setNested1(Nested1 nested1) {
            this.nested1 = nested1;
        }

        @Json
        public Nested2 getNested2() {
            return this.nested2;
        }

        public void setNested2(Nested2 nested2) {
            this.nested2 = nested2;
        }
    }

    public static interface JsonDao {
        @SqlUpdate(value="insert into subjects (subject) values(?)")
        public int insert(@Json JsonBean var1);

        @SqlQuery(value="select subject from subjects")
        @Json
        public List<JsonBean> select();

        @SqlUpdate(value="insert into subjects (subject) values(?)")
        public int insertOptional(@Json Optional<JsonBean> var1);

        @SqlQuery(value="select subject from subjects")
        @Json
        public List<Optional<JsonBean>> selectOptional();
    }

    public static class JsonBean {
        private final String food;
        private final int bitcoins;

        public JsonBean(String food, int bitcoins) {
            this.food = food;
            this.bitcoins = bitcoins;
        }

        public String getFood() {
            return this.food;
        }

        public int getBitcoins() {
            return this.bitcoins;
        }

        public boolean equals(Object x) {
            JsonBean other = (JsonBean)x;
            return this.bitcoins == other.bitcoins && Objects.equals(this.food, other.food);
        }

        public int hashCode() {
            return Objects.hash(this.food, this.bitcoins);
        }
    }
}

