/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.json;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.jdbi.v3.core.result.UnableToProduceResultException;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.json.Json;
import org.jdbi.v3.json.JsonPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.jdbi.v3.testing.JdbiRule;
import org.junit.Rule;
import org.junit.Test;

public class StubJsonMapperTest {
    @Rule
    public final JdbiRule h2 = JdbiRule.h2().withPlugin((JdbiPlugin)new SqlObjectPlugin()).withPlugin((JdbiPlugin)new JsonPlugin());

    @Test
    public void defaultFactoriesAreWorkingForSqlObject() {
        this.h2.getJdbi().useHandle(h -> {
            FooDao dao = (FooDao)h.attach(FooDao.class);
            dao.table();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> dao.insert(new Foo())).isInstanceOf(UnableToCreateStatementException.class)).hasMessageContaining("need to install").hasMessageContaining("a JsonMapper");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(dao::get).isInstanceOf(UnableToProduceResultException.class)).hasMessageContaining("need to install").hasMessageContaining("a JsonMapper");
        });
    }

    private static interface FooDao {
        @SqlUpdate(value="create table json(val varchar)")
        public void table();

        @SqlUpdate(value="insert into json(val) values(:json)")
        public void insert(@Json Foo var1);

        @SqlQuery(value="select '{}'")
        @Json
        public Foo get();
    }

    public static class Foo {
    }
}

