/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.lifetime;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.lifetime.KtAlwaysAccessibleLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeTokenFactory;
import org.jetbrains.kotlin.analysis.providers.KotlinModificationTrackerFactoryKt;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.ModificationTracker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/api/lifetime/KtAlwaysAccessibleLifetimeToken;", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "factory", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory;", "getFactory", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeTokenFactory;", "modificationTracker", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/ModificationTracker;", "onCreatedTimeStamp", "", "getInaccessibilityReason", "", "getInvalidationReason", "isAccessible", "", "isValid", "analysis-api"})
public final class KtAlwaysAccessibleLifetimeToken
extends KtLifetimeToken {
    @NotNull
    private final ModificationTracker modificationTracker;
    private final long onCreatedTimeStamp;
    @NotNull
    private final KtLifetimeTokenFactory factory;

    public KtAlwaysAccessibleLifetimeToken(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.modificationTracker = KotlinModificationTrackerFactoryKt.createProjectWideOutOfBlockModificationTracker((Project)project);
        this.onCreatedTimeStamp = this.modificationTracker.getModificationCount();
        this.factory = KtAlwaysAccessibleLifetimeTokenFactory.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return this.onCreatedTimeStamp == this.modificationTracker.getModificationCount();
    }

    @Override
    @NotNull
    public String getInvalidationReason() {
        if (this.onCreatedTimeStamp != this.modificationTracker.getModificationCount()) {
            return "PSI has changed since creation";
        }
        throw new IllegalStateException("Getting invalidation reason for valid validity token".toString());
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    @Override
    @NotNull
    public String getInaccessibilityReason() {
        throw new IllegalStateException("Getting inaccessibility reason for validity token when it is accessible".toString());
    }

    @Override
    @NotNull
    public KtLifetimeTokenFactory getFactory() {
        return this.factory;
    }
}

