/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.assignment.plugin.diagnostics;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.assignment.plugin.AssignmentPluginNames;
import org.jetbrains.kotlin.assignment.plugin.diagnostics.ErrorsAssignmentPlugin;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.extensions.AnnotationBasedExtension;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/assignment/plugin/diagnostics/AssignmentPluginDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "annotations", "", "", "(Ljava/util/List;)V", "annotationMatchingService", "Lorg/jetbrains/kotlin/assignment/plugin/diagnostics/AssignmentPluginDeclarationChecker$AnnotationMatchingService;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkAssignMethod", "method", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "receiverClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "isAssignMethod", "", "AnnotationMatchingService", "kotlin-assignment-compiler-plugin.k1"})
@SourceDebugExtension(value={"SMAP\nAssignmentPluginDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssignmentPluginDeclarationChecker.kt\norg/jetbrains/kotlin/assignment/plugin/diagnostics/AssignmentPluginDeclarationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class AssignmentPluginDeclarationChecker
implements DeclarationChecker {
    @NotNull
    private final List<String> annotations;
    @NotNull
    private final AnnotationMatchingService annotationMatchingService;

    public AssignmentPluginDeclarationChecker(@NotNull List<String> annotations) {
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        this.annotations = annotations;
        this.annotationMatchingService = new AnnotationMatchingService(this.annotations);
    }

    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (descriptor instanceof SimpleFunctionDescriptor) {
            KtFunction ktFunction;
            Object object;
            DeclarationDescriptor declarationDescriptor;
            if (!this.isAssignMethod((SimpleFunctionDescriptor)descriptor)) {
                return;
            }
            if (DescriptorUtilsKt.isExtension((DeclarationDescriptor)descriptor)) {
                ReceiverParameterDescriptor receiverParameterDescriptor = ((SimpleFunctionDescriptor)descriptor).getExtensionReceiverParameter();
                Object object2 = receiverParameterDescriptor != null && (receiverParameterDescriptor = receiverParameterDescriptor.getType()) != null && (receiverParameterDescriptor = receiverParameterDescriptor.getConstructor()) != null ? receiverParameterDescriptor.getDeclarationDescriptor() : (declarationDescriptor = null);
                object = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            } else {
                declarationDescriptor = ((SimpleFunctionDescriptor)descriptor).getContainingDeclaration();
                object = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            }
            ClassDescriptor receiverClass = object;
            KtFunction ktFunction2 = ktFunction = declaration instanceof KtFunction ? (KtFunction)declaration : null;
            if (receiverClass != null && ktFunction != null) {
                this.checkAssignMethod((SimpleFunctionDescriptor)descriptor, receiverClass, ktFunction, (DiagnosticSink)context.getTrace());
            }
        }
    }

    private final void checkAssignMethod(SimpleFunctionDescriptor method, ClassDescriptor receiverClass, KtFunction declaration, DiagnosticSink diagnosticHolder) {
        boolean bl;
        if (!this.annotationMatchingService.isAnnotated(receiverClass)) {
            return;
        }
        KotlinType kotlinType = method.getReturnType();
        if (kotlinType != null) {
            KotlinType it = kotlinType;
            boolean bl2 = false;
            bl = KotlinBuiltIns.isUnit((KotlinType)it);
        } else {
            bl = false;
        }
        if (!bl) {
            diagnosticHolder.report((Diagnostic)ErrorsAssignmentPlugin.DECLARATION_ERROR_ASSIGN_METHOD_SHOULD_RETURN_UNIT.on((PsiElement)declaration));
        }
    }

    private final boolean isAssignMethod(SimpleFunctionDescriptor $this$isAssignMethod) {
        return $this$isAssignMethod.getValueParameters().size() == 1 && Intrinsics.areEqual((Object)$this$isAssignMethod.getName(), (Object)AssignmentPluginNames.INSTANCE.getASSIGN_METHOD());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/assignment/plugin/diagnostics/AssignmentPluginDeclarationChecker$AnnotationMatchingService;", "Lorg/jetbrains/kotlin/extensions/AnnotationBasedExtension;", "annotations", "", "", "(Ljava/util/List;)V", "getAnnotations", "()Ljava/util/List;", "getAnnotationFqNames", "modifierListOwner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "isAnnotated", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kotlin-assignment-compiler-plugin.k1"})
    private static final class AnnotationMatchingService
    implements AnnotationBasedExtension {
        @NotNull
        private final List<String> annotations;

        public AnnotationMatchingService(@NotNull List<String> annotations) {
            Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
            this.annotations = annotations;
        }

        @NotNull
        public final List<String> getAnnotations() {
            return this.annotations;
        }

        @NotNull
        public List<String> getAnnotationFqNames(@Nullable KtModifierListOwner modifierListOwner) {
            return this.annotations;
        }

        public final boolean isAnnotated(@NotNull ClassDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            return this.hasSpecialAnnotation((DeclarationDescriptor)descriptor, null);
        }
    }
}

