/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.Difference;
import org.jetbrains.kotlin.incremental.DifferenceCalculator;
import org.jetbrains.kotlin.incremental.DifferenceCalculatorForPackageFacade;
import org.jetbrains.kotlin.incremental.PackagePartProtoData;
import org.jetbrains.kotlin.incremental.ProtoCompareGenerated;
import org.jetbrains.kotlin.incremental.ProtoDifferenceUtilsKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.protobuf.MessageLite;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/DifferenceCalculatorForPackageFacade;", "Lorg/jetbrains/kotlin/incremental/DifferenceCalculator;", "oldData", "Lorg/jetbrains/kotlin/incremental/PackagePartProtoData;", "newData", "(Lorg/jetbrains/kotlin/incremental/PackagePartProtoData;Lorg/jetbrains/kotlin/incremental/PackagePartProtoData;)V", "compareObject", "Lorg/jetbrains/kotlin/incremental/ProtoCompareGenerated;", "getCompareObject", "()Lorg/jetbrains/kotlin/incremental/ProtoCompareGenerated;", "difference", "Lorg/jetbrains/kotlin/incremental/Difference;", "kotlin-build-common"})
public final class DifferenceCalculatorForPackageFacade
extends DifferenceCalculator {
    @NotNull
    private final PackagePartProtoData oldData;
    @NotNull
    private final PackagePartProtoData newData;
    @NotNull
    private final ProtoCompareGenerated compareObject;

    public DifferenceCalculatorForPackageFacade(@NotNull PackagePartProtoData oldData, @NotNull PackagePartProtoData newData) {
        Intrinsics.checkNotNullParameter((Object)oldData, (String)"oldData");
        Intrinsics.checkNotNullParameter((Object)newData, (String)"newData");
        this.oldData = oldData;
        this.newData = newData;
        this.compareObject = new ProtoCompareGenerated(this.oldData.getNameResolver(), this.newData.getNameResolver(), ProtoDifferenceUtilsKt.getTypeTableOrNull(this.oldData.getProto()), ProtoDifferenceUtilsKt.getTypeTableOrNull(this.newData.getProto()));
    }

    @Override
    @NotNull
    protected ProtoCompareGenerated getCompareObject() {
        return this.compareObject;
    }

    @Override
    @NotNull
    public Difference difference() {
        ProtoBuf.Package oldProto = this.oldData.getProto();
        ProtoBuf.Package newProto = this.newData.getProto();
        EnumSet<ProtoCompareGenerated.ProtoBufPackageKind> diff = this.getCompareObject().difference(oldProto, newProto);
        boolean bl = false;
        HashSet<String> names = new HashSet<String>();
        for (ProtoCompareGenerated.ProtoBufPackageKind kind : diff) {
            Object object;
            ProtoCompareGenerated.ProtoBufPackageKind protoBufPackageKind;
            Intrinsics.checkNotNull((Object)((Object)kind));
            int n = WhenMappings.$EnumSwitchMapping$0[protoBufPackageKind.ordinal()];
            switch (n) {
                case 1: {
                    object = names.addAll(DifferenceCalculatorForPackageFacade.difference$calcDifferenceForNonPrivateMembers(oldProto, newProto, this, (Function1<? super ProtoBuf.Package, ? extends List<? extends MessageLite>>)((Function1)difference.unused.1.INSTANCE)));
                    break;
                }
                case 2: {
                    object = names.addAll(DifferenceCalculatorForPackageFacade.difference$calcDifferenceForNonPrivateMembers(oldProto, newProto, this, (Function1<? super ProtoBuf.Package, ? extends List<? extends MessageLite>>)((Function1)difference.unused.2.INSTANCE)));
                    break;
                }
                case 3: {
                    object = names.addAll(DifferenceCalculatorForPackageFacade.difference$calcDifferenceForNonPrivateMembers(oldProto, newProto, this, (Function1<? super ProtoBuf.Package, ? extends List<? extends MessageLite>>)((Function1)difference.unused.3.INSTANCE)));
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    object = Unit.INSTANCE;
                    break;
                }
                case 7: {
                    object = Unit.INSTANCE;
                    break;
                }
                case 8: {
                    object = Unit.INSTANCE;
                    break;
                }
                case 9: {
                    object = Unit.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Unit unit = object;
        }
        return new Difference(false, false, names, null, 11, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<String> difference$calcDifferenceForNonPrivateMembers(ProtoBuf.Package oldProto, ProtoBuf.Package newProto, DifferenceCalculatorForPackageFacade this$0, Function1<? super ProtoBuf.Package, ? extends List<? extends MessageLite>> members) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNotTo$iv$iv2;
        Iterable $this$filterNot$iv = (Iterable)members.invoke((Object)oldProto);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
            MessageLite it = (MessageLite)element$iv$iv;
            boolean bl = false;
            if (ProtoDifferenceUtilsKt.isPrivate(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List oldMembers = (List)destination$iv$iv;
        Iterable $this$filterNot$iv2 = (Iterable)members.invoke((Object)newProto);
        boolean $i$f$filterNot2 = false;
        destination$iv$iv = $this$filterNot$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo2 = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            MessageLite it = (MessageLite)element$iv$iv;
            boolean bl = false;
            if (ProtoDifferenceUtilsKt.isPrivate(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List newMembers = (List)destination$iv$iv2;
        return this$0.calcDifferenceForMembers(oldMembers, newMembers);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoCompareGenerated.ProtoBufPackageKind.values().length];
            nArray[ProtoCompareGenerated.ProtoBufPackageKind.FUNCTION_LIST.ordinal()] = 1;
            nArray[ProtoCompareGenerated.ProtoBufPackageKind.PROPERTY_LIST.ordinal()] = 2;
            nArray[ProtoCompareGenerated.ProtoBufPackageKind.TYPE_ALIAS_LIST.ordinal()] = 3;
            nArray[ProtoCompareGenerated.ProtoBufPackageKind.VERSION_REQUIREMENT_TABLE.ordinal()] = 4;
            nArray[ProtoCompareGenerated.ProtoBufPackageKind.JVM_EXT_PACKAGE_MODULE_NAME.ordinal()] = 5;
            nArray[ProtoCompareGenerated.ProtoBufPackageKind.JS_EXT_PACKAGE_FQ_NAME.ordinal()] = 6;
            nArray[ProtoCompareGenerated.ProtoBufPackageKind.JVM_EXT_PACKAGE_LOCAL_VARIABLE_LIST.ordinal()] = 7;
            nArray[ProtoCompareGenerated.ProtoBufPackageKind.BUILT_INS_EXT_PACKAGE_FQ_NAME.ordinal()] = 8;
            nArray[ProtoCompareGenerated.ProtoBufPackageKind.KLIB_EXT_PACKAGE_FQ_NAME.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

