/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.FreeThreadedFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubTreeBuilder;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.indexing.FileContentImpl;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexingDataKeys;

public class StubTextInconsistencyException
extends RuntimeException
implements ExceptionWithAttachments {
    private final String myStubsFromText;
    private final String myStubsFromPsi;
    private final String myFileName;
    private final String myFileText;

    private StubTextInconsistencyException(String message2, PsiFile file2, List<PsiFileStub> fromText, List<PsiFileStub> fromPsi) {
        super(message2);
        this.myStubsFromText = StringUtil.join(fromText, DebugUtil::stubTreeToString, "\n");
        this.myStubsFromPsi = StringUtil.join(fromPsi, DebugUtil::stubTreeToString, "\n");
        this.myFileName = file2.getName();
        this.myFileText = file2.getText();
    }

    @NotNull
    public String getStubsFromText() {
        String string = this.myStubsFromText;
        if (string == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getStubsFromPsi() {
        String string = this.myStubsFromPsi;
        if (string == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public Attachment[] getAttachments() {
        Attachment[] attachmentArray = new Attachment[]{new Attachment(this.myFileName, this.myFileText), new Attachment("stubsRestoredFromText.txt", this.myStubsFromText), new Attachment("stubsFromExistingPsi.txt", this.myStubsFromPsi)};
        if (attachmentArray == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(2);
        }
        return attachmentArray;
    }

    public static void checkStubTextConsistency(@NotNull PsiFile file2) throws StubTextInconsistencyException {
        if (file2 == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(3);
        }
        PsiUtilCore.ensureValid(file2);
        FileViewProvider viewProvider = file2.getViewProvider();
        if (viewProvider instanceof FreeThreadedFileViewProvider || viewProvider.getVirtualFile() instanceof LightVirtualFile) {
            return;
        }
        PsiFile bindingRoot = viewProvider.getStubBindingRoot();
        if (!(bindingRoot instanceof PsiFileImpl)) {
            return;
        }
        IStubFileElementType fileElementType = ((PsiFileImpl)bindingRoot).getElementTypeForStubBuilder();
        if (fileElementType == null || !fileElementType.shouldBuildStubFor(viewProvider.getVirtualFile())) {
            return;
        }
        List<PsiFileStub> fromText = StubTextInconsistencyException.restoreStubsFromText(viewProvider);
        List<PsiFileStub> fromPsi = ContainerUtil.map(StubTreeBuilder.getStubbedRoots(viewProvider), p -> ((PsiFileImpl)p.getSecond()).calcStubTree().getRoot());
        if (fromPsi.size() != fromText.size()) {
            throw new StubTextInconsistencyException("Inconsistent stub roots: PSI says it's " + ContainerUtil.map(fromPsi, s -> s.getType()) + " but re-parsing the text gives " + ContainerUtil.map(fromText, s -> s.getType()), file2, fromText, fromPsi);
        }
        for (int i = 0; i < fromPsi.size(); ++i) {
            PsiFileStub psiStub = fromPsi.get(i);
            if (DebugUtil.stubTreeToString(psiStub).equals(DebugUtil.stubTreeToString(fromText.get(i)))) continue;
            throw new StubTextInconsistencyException("Stub is inconsistent with text in " + file2.getLanguage(), file2, fromText, fromPsi);
        }
    }

    @NotNull
    private static List<PsiFileStub> restoreStubsFromText(FileViewProvider viewProvider) {
        FileContentImpl fc = new FileContentImpl(viewProvider.getVirtualFile(), viewProvider.getContents(), 0L);
        fc.putUserData(IndexingDataKeys.PROJECT, viewProvider.getManager().getProject());
        PsiFileStubImpl copyTree = (PsiFileStubImpl)StubTreeBuilder.buildStubTree(fc);
        List<PsiFileStub> list2 = copyTree == null ? Collections.emptyList() : Arrays.asList(copyTree.getStubRoots());
        if (list2 == null) {
            StubTextInconsistencyException.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTextInconsistencyException";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubsFromText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubsFromPsi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/stubs/StubTextInconsistencyException";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreStubsFromText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkStubTextConsistency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

